/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.routing.core.api.operation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.ecm.platform.task.Task;
import org.nuxeo.ecm.platform.task.TaskService;
import org.nuxeo.ecm.platform.usermanager.UserManager;

@Operation(id="Context.GetOpenTasks", category="Workflow Context", label="Get open tasks", requires="Workflow", description="Returns all open tasks for the input document(s). If the operation is invoked with parameters, all tasks instances for the given 'processId' originating from the given 'nodeId' are returned. The 'processId' is the id of the document representing the workflow instance. The parameter 'username' is used to fetch only tasks assigned to the given user. Tasks are queried using an unrestricted session.")
public class GetOpenTasksOperation {
    public static final String ID = "Context.GetOpenTasks";
    @Context
    protected CoreSession session;
    @Param(name="nodeId", required=false)
    protected String nodeId;
    @Param(name="processId", required=false)
    protected String processId;
    @Param(name="username", required=false)
    protected String username;
    @Context
    protected TaskService taskService;
    @Context
    protected UserManager userManager;

    @OperationMethod
    public DocumentModelList getAllTasks(DocumentModel doc) throws ClientException {
        DocumentModelListImpl taskDocs = new DocumentModelListImpl();
        List tasks = new ArrayList();
        if (this.nodeId == null && this.processId == null) {
            NuxeoPrincipal principal = this.username != null ? this.userManager.getPrincipal(this.username) : null;
            tasks = this.taskService.getTaskInstances(doc, principal, this.session);
            for (Task task : tasks) {
                taskDocs.add((Object)task.getDocument());
            }
            return taskDocs;
        }
        if (this.nodeId == null || this.processId == null) {
            throw new ClientException("Need both nodeId and processId to invoke the operation with parameters");
        }
        tasks = this.taskService.getAllTaskInstances(this.processId, this.nodeId, this.session);
        for (Task task : tasks) {
            if (!doc.getId().equals(task.getTargetDocumentId())) continue;
            if (this.username == null) {
                taskDocs.add((Object)task.getDocument());
                continue;
            }
            if (!task.getActors().contains(this.username)) continue;
            taskDocs.add((Object)task.getDocument());
        }
        return taskDocs;
    }

    @OperationMethod
    public DocumentModelList getAllTasks(DocumentModelList docs) throws ClientException {
        DocumentModelListImpl taskDocs = new DocumentModelListImpl();
        for (DocumentModel doc : docs) {
            taskDocs.addAll((Collection)this.getAllTasks(doc));
        }
        return taskDocs;
    }
}

