/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.interactive.digitalsignature.visible;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.imageio.ImageIO;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.bouncycastle.util.Arrays;

public class PDVisibleSignDesigner {
    private Float sigImgWidth;
    private Float sigImgHeight;
    private float xAxis;
    private float yAxis;
    private float pageHeight;
    private float pageWidth;
    private InputStream imgageStream;
    private String signatureFieldName = "sig";
    private byte[] formaterRectangleParams = new byte[]{0, 0, 100, 50};
    private byte[] AffineTransformParams = new byte[]{1, 0, 0, 1, 0, 0};
    private float imageSizeInPercents;
    private PDDocument document = null;

    public PDVisibleSignDesigner(InputStream originalDocumenStream, InputStream imageStream, int page) throws IOException {
        this.signatureImageStream(imageStream);
        this.document = PDDocument.load(originalDocumenStream);
        this.calculatePageSize(this.document, page);
    }

    public PDVisibleSignDesigner(String documentPath, InputStream imageStream, int page) throws IOException {
        this.signatureImageStream(imageStream);
        this.document = PDDocument.load(documentPath);
        this.calculatePageSize(this.document, page);
        this.document.close();
    }

    public PDVisibleSignDesigner(PDDocument doc, InputStream imageStream, int page) throws IOException {
        this.signatureImageStream(imageStream);
        this.calculatePageSize(doc, page);
    }

    private void calculatePageSize(PDDocument document, int page) {
        if (page < 1) {
            throw new IllegalArgumentException("First page of pdf is 1, not " + page);
        }
        List pages = document.getDocumentCatalog().getAllPages();
        PDPage firstPage = (PDPage)pages.get(page - 1);
        PDRectangle mediaBox = firstPage.findMediaBox();
        this.pageHeight(mediaBox.getHeight());
        float x = this.pageWidth = mediaBox.getWidth();
        float y = 0.0f;
        this.pageWidth += y;
        float tPercent = 100.0f * y / (x + y);
        this.imageSizeInPercents = 100.0f - tPercent;
    }

    public PDVisibleSignDesigner signatureImage(String path) throws IOException {
        FileInputStream fin = new FileInputStream(path);
        return this.signatureImageStream(fin);
    }

    public PDVisibleSignDesigner zoom(float percent) {
        this.sigImgHeight = Float.valueOf(this.sigImgHeight.floatValue() + this.sigImgHeight.floatValue() * percent / 100.0f);
        this.sigImgWidth = Float.valueOf(this.sigImgWidth.floatValue() + this.sigImgWidth.floatValue() * percent / 100.0f);
        return this;
    }

    public PDVisibleSignDesigner coordinates(float x, float y) {
        this.xAxis(x);
        this.yAxis(y);
        return this;
    }

    public float getxAxis() {
        return this.xAxis;
    }

    public PDVisibleSignDesigner xAxis(float xAxis) {
        this.xAxis = xAxis;
        return this;
    }

    public float getyAxis() {
        return this.yAxis;
    }

    public PDVisibleSignDesigner yAxis(float yAxis) {
        this.yAxis = yAxis;
        return this;
    }

    public float getWidth() {
        return this.sigImgWidth.floatValue();
    }

    public PDVisibleSignDesigner width(float signatureImgWidth) {
        this.sigImgWidth = Float.valueOf(signatureImgWidth);
        return this;
    }

    public float getHeight() {
        return this.sigImgHeight.floatValue();
    }

    public PDVisibleSignDesigner height(float signatureImgHeight) {
        this.sigImgHeight = Float.valueOf(signatureImgHeight);
        return this;
    }

    protected float getTemplateHeight() {
        return this.getPageHeight();
    }

    private PDVisibleSignDesigner pageHeight(float templateHeight) {
        this.pageHeight = templateHeight;
        return this;
    }

    public String getSignatureFieldName() {
        return this.signatureFieldName;
    }

    public PDVisibleSignDesigner signatureFieldName(String signatureFieldName) {
        this.signatureFieldName = signatureFieldName;
        return this;
    }

    public InputStream getImageStream() {
        return this.imgageStream;
    }

    private PDVisibleSignDesigner signatureImageStream(InputStream imageStream) throws IOException {
        int len;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((len = imageStream.read(buffer)) > -1) {
            baos.write(buffer, 0, len);
        }
        baos.flush();
        baos.close();
        byte[] byteArray = baos.toByteArray();
        byte[] byteArraySecond = Arrays.clone((byte[])byteArray);
        ByteArrayInputStream inputForBufferedImage = new ByteArrayInputStream(byteArray);
        ByteArrayInputStream revertInputStream = new ByteArrayInputStream(byteArraySecond);
        if (this.sigImgHeight == null || this.sigImgWidth == null) {
            this.calcualteImageSize(inputForBufferedImage);
        }
        this.imgageStream = revertInputStream;
        return this;
    }

    private void calcualteImageSize(InputStream fis) throws IOException {
        BufferedImage bimg = ImageIO.read(fis);
        int width = bimg.getWidth();
        int height = bimg.getHeight();
        this.sigImgHeight = Float.valueOf(height);
        this.sigImgWidth = Float.valueOf(width);
    }

    public byte[] getAffineTransformParams() {
        return this.AffineTransformParams;
    }

    public PDVisibleSignDesigner affineTransformParams(byte[] affineTransformParams) {
        this.AffineTransformParams = affineTransformParams;
        return this;
    }

    public byte[] getFormaterRectangleParams() {
        return this.formaterRectangleParams;
    }

    public PDVisibleSignDesigner formaterRectangleParams(byte[] formaterRectangleParams) {
        this.formaterRectangleParams = formaterRectangleParams;
        return this;
    }

    public float getPageWidth() {
        return this.pageWidth;
    }

    public PDVisibleSignDesigner pageWidth(float pageWidth) {
        this.pageWidth = pageWidth;
        return this;
    }

    public float getPageHeight() {
        return this.pageHeight;
    }

    public float getImageSizeInPercents() {
        return this.imageSizeInPercents;
    }

    public void imageSizeInPercents(float imageSizeInPercents) {
        this.imageSizeInPercents = imageSizeInPercents;
    }

    public String getSignatureText() {
        throw new UnsupportedOperationException("That method is not yet implemented");
    }

    public PDVisibleSignDesigner signatureText(String signatureText) {
        throw new UnsupportedOperationException("That method is not yet implemented");
    }
}

