/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.annotations.service;

import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.VersioningOption;
import org.nuxeo.ecm.core.api.impl.UserPrincipal;
import org.nuxeo.ecm.core.storage.sql.DatabaseHelper;
import org.nuxeo.ecm.platform.annotations.api.Annotation;
import org.nuxeo.ecm.platform.annotations.api.AnnotationException;
import org.nuxeo.ecm.platform.annotations.repository.AbstractRepositoryTestCase;
import org.nuxeo.ecm.platform.url.DocumentViewImpl;
import org.nuxeo.ecm.platform.url.api.DocumentView;

public class AnnotationRepositoryTest
extends AbstractRepositoryTestCase {
    private static final Log log = LogFactory.getLog(AnnotationRepositoryTest.class);
    private static final String SERVER1 = "http://server1.com/nuxeo/";
    private static final String SERVER2 = "http://server2.com/nuxeo/";
    private DocumentModel version1;
    private final NuxeoPrincipal user = new UserPrincipal("bob", new ArrayList(), false, false);

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.setUpRepository();
    }

    @Test
    public void testAnnotateDocuments() throws Exception {
        this.waitForAsyncExec();
        Assert.assertNotNull((Object)this.session);
        DocumentModel myfileModel = this.session.createDocumentModel(this.session.getRootDocument().getPathAsString(), "999", "File");
        DocumentModel myfile = this.session.createDocument(myfileModel);
        Assert.assertNotNull((Object)myfile);
        this.session.save();
        this.closeSession();
        this.waitForAsyncExec();
        DatabaseHelper.DATABASE.sleepForFulltext();
        this.openSession();
        DocumentModelList results = this.session.query("SELECT * FROM Document WHERE ecm:fulltext = 'zombie'", 10);
        Assert.assertEquals((long)0L, (long)results.size());
        String uriMyfileServer1 = this.viewCodecManager.getUrlFromDocumentView((DocumentView)new DocumentViewImpl(myfile), true, SERVER1);
        Assert.assertNotNull((Object)uriMyfileServer1);
        String uriMyFileserver2 = this.viewCodecManager.getUrlFromDocumentView((DocumentView)new DocumentViewImpl(myfile), true, SERVER2);
        Assert.assertNotNull((Object)uriMyFileserver2);
        Annotation annotation = this.getAnnotation(uriMyfileServer1, 1);
        annotation.setBodyText("This is a Zombie annotation text");
        this.service.addAnnotation(annotation, this.user, SERVER1);
        this.sameDocumentFrom2Servers(uriMyfileServer1, uriMyFileserver2);
        this.session.save();
        this.closeSession();
        this.waitForAsyncExec();
        DatabaseHelper.DATABASE.sleepForFulltext();
        this.openSession();
        results = this.session.query("SELECT * FROM Document WHERE ecm:fulltext = 'zombie'", 10);
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((Object)myfile.getRef(), (Object)((DocumentModel)results.get(0)).getRef());
        myfile = this.session.getDocument(myfile.getRef());
        myfile.putContextData("VersioningOption", (Serializable)VersioningOption.MAJOR);
        myfile.putContextData("CheckinComment", (Serializable)((Object)"I would like to create a new major version"));
        myfile = this.session.saveDocument(myfile);
        this.session.save();
        this.closeSession();
        this.waitForAsyncExec();
        DatabaseHelper.DATABASE.sleepForFulltext();
        this.openSession();
        results = this.session.query("SELECT * FROM Document WHERE ecm:fulltext = 'zombie'", 10);
    }

    protected void annotationOnNewVersion(String u1) throws AnnotationException, IOException, URISyntaxException {
        this.annotation = this.service.addAnnotation(this.getAnnotation(u1, 2), this.user, SERVER1);
        Assert.assertNotNull((Object)this.annotation);
        List annotations = this.service.queryAnnotations(new URI(u1), null, this.user);
        Assert.assertEquals((long)1L, (long)annotations.size());
        String versionUrl = this.viewCodecManager.getUrlFromDocumentView((DocumentView)new DocumentViewImpl(this.version1), true, SERVER1);
        annotations = this.service.queryAnnotations(new URI(versionUrl), null, this.user);
        Assert.assertEquals((long)1L, (long)annotations.size());
    }

    protected void newVersionSameAnnotations(CoreSession session, DocumentModel myfile, String uriAnnotatedDoc) throws AnnotationException, URISyntaxException, ClientException {
        List annotations = this.service.queryAnnotations(new URI(uriAnnotatedDoc), null, this.user);
        log.debug((Object)(annotations.size() + " annotations for: " + uriAnnotatedDoc));
        Assert.assertEquals((long)0L, (long)annotations.size());
        List versions = session.getVersions(myfile.getRef());
        Assert.assertEquals((long)1L, (long)versions.size());
        this.version1 = (DocumentModel)versions.get(0);
        String versionUrl = this.viewCodecManager.getUrlFromDocumentView((DocumentView)new DocumentViewImpl(this.version1), true, SERVER1);
        Assert.assertNotNull((Object)versionUrl);
        annotations = this.service.queryAnnotations(new URI(versionUrl), null, this.user);
        log.debug((Object)(annotations.size() + " annotations for: " + versionUrl));
        Assert.assertEquals((long)1L, (long)annotations.size());
    }

    protected void createVersion(CoreSession session, DocumentModel myfile, String comment) throws ClientException {
        session.checkIn(myfile.getRef(), VersioningOption.MAJOR, comment);
        session.checkOut(myfile.getRef());
        session.save();
        this.waitForAsyncExec();
    }

    protected void sameDocumentFrom2Servers(String u1, String u2) throws AnnotationException, URISyntaxException {
        List annotations = this.service.queryAnnotations(new URI(u1), null, this.user);
        Assert.assertEquals((long)1L, (long)annotations.size());
        annotations = this.service.queryAnnotations(new URI(u2), null, this.user);
        Assert.assertEquals((long)1L, (long)annotations.size());
    }
}

