/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.annotations.repository;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.util.List;
import javax.inject.Inject;
import org.h2.util.IOUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.runner.RunWith;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.event.EventService;
import org.nuxeo.ecm.core.event.impl.EventServiceImpl;
import org.nuxeo.ecm.core.test.RepositorySettings;
import org.nuxeo.ecm.platform.annotations.api.Annotation;
import org.nuxeo.ecm.platform.annotations.api.AnnotationException;
import org.nuxeo.ecm.platform.annotations.api.AnnotationManager;
import org.nuxeo.ecm.platform.annotations.api.AnnotationsService;
import org.nuxeo.ecm.platform.annotations.repository.service.AnnotationFeature;
import org.nuxeo.ecm.platform.url.DocumentViewImpl;
import org.nuxeo.ecm.platform.url.api.DocumentView;
import org.nuxeo.ecm.platform.url.api.DocumentViewCodecManager;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;

@RunWith(value=FeaturesRunner.class)
@Features(value={AnnotationFeature.class})
public abstract class AbstractRepositoryTestCase {
    protected final AnnotationManager manager = new AnnotationManager();
    protected URI uri;
    protected Annotation annotation;
    @Inject
    protected AnnotationsService service;
    @Inject
    protected DocumentViewCodecManager viewCodecManager;
    @Inject
    protected CoreSession session;
    @Inject
    RepositorySettings repo;

    @Before
    public void setUp() throws Exception {
        Assert.assertNotNull((Object)this.viewCodecManager);
        Assert.assertNotNull((Object)this.manager);
        InputStream is = this.getClass().getResourceAsStream("/annotea-spec-post.xml");
        Assert.assertNotNull((Object)is);
        this.annotation = this.manager.getAnnotation(is);
    }

    protected void setUpRepository() throws Exception {
        Assert.assertNotNull((Object)this.session);
        DocumentModel root = this.session.getRootDocument();
        Assert.assertNotNull((Object)root);
        DocumentModel model = this.session.createDocumentModel(root.getPathAsString(), "1", "File");
        DocumentModel sectionModel = this.session.createDocumentModel(root.getPathAsString(), "2", "Section");
        Assert.assertNotNull((Object)sectionModel);
        DocumentModel section = this.session.createDocument(sectionModel);
        Assert.assertNotNull((Object)section);
        DocumentModel section1Model = this.session.createDocumentModel(section.getPathAsString(), "3", "Folder");
        DocumentModel section1 = this.session.createDocument(section1Model);
        Assert.assertNotNull((Object)section1);
        DocumentModel section2Model = this.session.createDocumentModel(section.getPathAsString(), "3", "Folder");
        DocumentModel section2 = this.session.createDocument(section2Model);
        Assert.assertNotNull((Object)section2);
        DocumentModel section3Model = this.session.createDocumentModel(section.getPathAsString(), "3", "Folder");
        DocumentModel section3 = this.session.createDocument(section3Model);
        Assert.assertNotNull((Object)section3);
        DocumentModel doc = this.session.createDocument(model);
        Assert.assertNotNull((Object)doc);
        this.session.saveDocument(doc);
        this.session.publishDocument(doc, section1);
        doc.setPropertyValue("dc:description", null);
        this.session.saveDocument(doc);
        this.session.publishDocument(doc, section2);
        doc.setPropertyValue("dc:description", null);
        this.session.saveDocument(doc);
        this.session.publishDocument(doc, section3);
        this.session.save();
        List l = this.session.getVersions(doc.getRef());
        Assert.assertFalse((boolean)doc.isVersion());
        Assert.assertEquals((long)3L, (long)l.size());
        DocumentModelList proxies = this.session.getProxies(doc.getRef(), null);
        Assert.assertNotNull((Object)proxies);
        Assert.assertEquals((long)3L, (long)proxies.size());
        String url = this.viewCodecManager.getUrlFromDocumentView((DocumentView)new DocumentViewImpl(doc), true, "http://localhost/nuxeo/");
        Assert.assertNotNull((Object)url);
        this.uri = new URI(url.toString());
        this.waitForAsyncExec();
    }

    protected Annotation getAnnotation(String url, int x) throws IOException, AnnotationException {
        InputStream is = this.getClass().getResourceAsStream("/annotation" + x + ".xml");
        String template = IOUtils.readStringAndClose((Reader)new InputStreamReader(is), (int)-1);
        template = template.replaceAll("docUrl", url);
        is = new ByteArrayInputStream(template.getBytes("UTF-8"));
        return this.manager.getAnnotation(is);
    }

    protected void waitForAsyncExec() {
        EventServiceImpl evtService = (EventServiceImpl)Framework.getLocalService(EventService.class);
        evtService.waitForAsyncCompletion();
    }

    protected void openSession() {
        this.session = this.repo.createSession();
    }

    protected void closeSession() {
        this.repo.releaseSession();
        this.session = null;
    }
}

