/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.login.test;

import java.io.IOException;
import java.security.Principal;
import java.security.acl.Group;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.SystemPrincipal;
import org.nuxeo.ecm.platform.api.login.RestrictedLoginHelper;
import org.nuxeo.ecm.platform.api.login.UserIdentificationInfo;
import org.nuxeo.ecm.platform.api.login.UserIdentificationInfoCallback;
import org.nuxeo.ecm.platform.login.CallbackResult;
import org.nuxeo.ecm.platform.login.GroupImpl;
import org.nuxeo.ecm.platform.login.LoginPlugin;
import org.nuxeo.ecm.platform.login.LoginPluginDescriptor;
import org.nuxeo.ecm.platform.login.LoginPluginRegistry;
import org.nuxeo.ecm.platform.login.NuxeoAbstractServerLoginModule;
import org.nuxeo.ecm.platform.login.PrincipalImpl;
import org.nuxeo.ecm.platform.usermanager.NuxeoPrincipalImpl;
import org.nuxeo.runtime.RuntimeService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.api.login.LoginComponent;

public class DummyNuxeoLoginModule
extends NuxeoAbstractServerLoginModule {
    private static final Log log = LogFactory.getLog(DummyNuxeoLoginModule.class);
    private Random random;
    private NuxeoPrincipal identity;
    private LoginPluginRegistry loginPluginManager;
    private boolean useUserIdentificationInfoCB = false;
    public static final String ADMINISTRATOR_USERNAME = "Administrator";
    public final List<String> groupsToAdd = new ArrayList<String>();

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        String useUIICB = (String)options.get("useUserIdentificationInfoCB");
        if (useUIICB != null && useUIICB.equalsIgnoreCase("true")) {
            this.useUserIdentificationInfoCB = true;
        }
        super.initialize(subject, callbackHandler, sharedState, options);
        this.random = new Random(System.currentTimeMillis());
        log.debug((Object)"DummyNuxeoLoginModule initialized");
        try {
            RuntimeService runtime = Framework.getRuntime();
            this.loginPluginManager = (LoginPluginRegistry)runtime.getComponent(LoginPluginRegistry.NAME);
        }
        catch (Throwable t) {
            log.error((Object)("Unable to load Plugin Registry : " + t.getMessage()));
        }
    }

    protected Group[] getRoleSets() throws LoginException {
        String username = this.identity.getName();
        List roles = this.identity.getRoles();
        GroupImpl roleSet = new GroupImpl("Roles");
        log.debug((Object)("Getting roles for user=" + username));
        for (String roleName : roles) {
            PrincipalImpl role = new PrincipalImpl(roleName);
            log.debug((Object)("Found role=" + roleName));
            roleSet.addMember((Principal)role);
        }
        GroupImpl callerPrincipal = new GroupImpl("CallerPrincipal");
        callerPrincipal.addMember((Principal)this.identity);
        return new Group[]{roleSet, callerPrincipal};
    }

    protected NuxeoPrincipal getPrincipal() throws LoginException {
        CallbackResult result;
        UserIdentificationInfo userIdent = null;
        NameCallback nc = new NameCallback("Username: ", "anonymous");
        PasswordCallback pc = new PasswordCallback("Password: ", false);
        UserIdentificationInfoCallback uic = new UserIdentificationInfoCallback();
        boolean cb_handled = false;
        try {
            if (this.useUserIdentificationInfoCB) {
                this.callbackHandler.handle(new Callback[]{uic});
                userIdent = uic.getUserInfo();
                cb_handled = true;
            }
        }
        catch (UnsupportedCallbackException e) {
            log.debug((Object)"UserIdentificationInfoCallback is not supported");
        }
        catch (IOException e) {
            log.warn((Object)("Error calling callback handler with UserIdentificationInfoCallback : " + e.getMessage()));
        }
        Principal principal = null;
        Object credential = null;
        if (!cb_handled && (result = this.loginPluginManager.handleSpecifcCallbacks(this.callbackHandler)) != null && result.cb_handled) {
            if (result.userIdent != null && result.userIdent.containsValidIdentity()) {
                userIdent = result.userIdent;
                cb_handled = true;
            } else {
                principal = result.principal;
                credential = result.credential;
                if (principal != null) {
                    cb_handled = true;
                }
            }
        }
        if (!cb_handled) {
            LoginException le;
            try {
                this.callbackHandler.handle(new Callback[]{nc, pc});
                cb_handled = true;
            }
            catch (UnsupportedCallbackException e) {
                le = new LoginException("Authentications Failure - " + e.getMessage());
                le.initCause(e);
            }
            catch (IOException e) {
                le = new LoginException("Authentications Failure - " + e.getMessage());
                le.initCause(e);
            }
        }
        try {
            if (userIdent != null && userIdent.containsValidIdentity()) {
                NuxeoPrincipal nxp = this.validateUserIdentity(userIdent);
                if (nxp != null) {
                    this.sharedState.put("javax.security.auth.login.name", nxp.getName());
                    this.sharedState.put("javax.security.auth.login.password", userIdent);
                }
                return nxp;
            }
            if (LoginComponent.isSystemLogin(principal)) {
                return new SystemPrincipal(principal.getName());
            }
            if (principal != null) {
                String password = null;
                if (credential instanceof char[]) {
                    password = new String((char[])credential);
                } else if (credential != null) {
                    password = credential.toString();
                }
                return this.validateUsernamePassword(principal.getName(), password);
            }
            String username = nc.getName();
            if (username == null) {
                return null;
            }
            char[] password = pc.getPassword();
            return this.validateUsernamePassword(username, password != null ? new String(password) : null);
        }
        catch (LoginException e) {
            throw e;
        }
        catch (Exception e) {
            String msg = "Authentication failed: " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw (LoginException)new LoginException(msg).initCause(e);
        }
    }

    public boolean login() throws LoginException {
        this.loginOk = false;
        this.identity = this.getPrincipal();
        if (this.identity == null) {
            throw new LoginException("Authentication Failed");
        }
        if (RestrictedLoginHelper.isRestrictedModeActivated() && !this.identity.isAdministrator()) {
            throw new LoginException("Only Administrators can login when restricted mode is activated");
        }
        this.loginOk = true;
        log.trace((Object)("User '" + this.identity + "' authenticated"));
        return true;
    }

    public Principal getIdentity() {
        return this.identity;
    }

    public Principal createIdentity(String username) throws LoginException {
        log.debug((Object)("createIdentity: " + username));
        try {
            boolean isAdmin = false;
            if (ADMINISTRATOR_USERNAME.equalsIgnoreCase(username)) {
                isAdmin = true;
            }
            NuxeoPrincipalImpl principal = new NuxeoPrincipalImpl(username, false, isAdmin);
            String principalId = String.valueOf(this.random.nextLong());
            principal.setPrincipalId(principalId);
            principal.allGroups.add("Everyone");
            return principal;
        }
        catch (Exception e) {
            log.error((Object)"createIdentity failed", (Throwable)e);
            LoginException le = new LoginException("createIdentity failed for user " + username);
            le.initCause(e);
            throw le;
        }
    }

    protected NuxeoPrincipal validateUserIdentity(UserIdentificationInfo userIdent) throws Exception {
        String username;
        String loginPluginName = userIdent.getLoginPluginName();
        if (loginPluginName == null) {
            return (NuxeoPrincipal)this.createIdentity(userIdent.getUserName());
        }
        LoginPlugin lp = this.loginPluginManager.getPlugin(loginPluginName);
        if (lp == null) {
            log.error((Object)"Can't authenticate against a null loginModul plugin");
            return null;
        }
        LoginPluginDescriptor lpd = this.loginPluginManager.getPluginDescriptor(loginPluginName);
        if (!lpd.getInitialized()) {
            boolean init;
            Map loginParams;
            HashMap existingParams = lp.getParameters();
            if (existingParams == null) {
                existingParams = new HashMap();
            }
            if ((loginParams = userIdent.getLoginParameters()) != null) {
                existingParams.putAll(loginParams);
            }
            if (init = lp.initLoginModule().booleanValue()) {
                lpd.setInitialized(true);
            } else {
                log.error((Object)("Unable to initialize LoginModulePlugin " + lp.getName()));
                return null;
            }
        }
        if ((username = lp.validatedUserIdentity(userIdent)) == null) {
            return null;
        }
        return (NuxeoPrincipal)this.createIdentity(username);
    }

    protected NuxeoPrincipal validateUsernamePassword(String username, String password) throws Exception {
        return (NuxeoPrincipal)this.createIdentity(username);
    }
}

