/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.oauth2;

import com.google.api.client.auth.oauth2.AuthorizationCodeFlow;
import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.auth.oauth2.TokenResponse;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson.JacksonFactory;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.nuxeo.ecm.platform.oauth2.providers.NuxeoOAuth2ServiceProvider;
import org.nuxeo.ecm.platform.oauth2.providers.OAuth2ServiceProviderRegistry;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.ecm.webengine.model.impl.ModuleRoot;
import org.nuxeo.ecm.webengine.oauth2.WEOAuthConstants;
import org.nuxeo.runtime.api.Framework;

@Path(value="/oauth2")
@Produces(value={"text/html;charset=UTF-8"})
@WebObject(type="oauth2")
public class Root
extends ModuleRoot {
    private static final HttpTransport HTTP_TRANSPORT = new NetHttpTransport();
    private static final JsonFactory JSON_FACTORY = new JacksonFactory();

    @GET
    @Path(value="{serviceProviderName}/callback")
    public Object doGet(@PathParam(value="serviceProviderName") String serviceProviderName, @QueryParam(value="code") String code, @QueryParam(value="error") String error, @DefaultValue(value="false") @QueryParam(value="app") boolean isInstalledApp) throws Exception {
        if (error != null && error.length() > 0) {
            return Response.status((int)406).entity((Object)("There was an error: \"" + error + "\".")).build();
        }
        if (code == null || code.isEmpty()) {
            return Response.status((int)400).entity((Object)"There is not code provided as QueryParam.").build();
        }
        NuxeoOAuth2ServiceProvider provider = Root.getServiceProvider(serviceProviderName);
        if (provider == null) {
            return Response.status((int)404).entity((Object)("No service provider called: \"" + serviceProviderName + "\".")).build();
        }
        AuthorizationCodeFlow flow = provider.getAuthorizationCodeFlow(HTTP_TRANSPORT, JSON_FACTORY);
        String redirectUri = this.ctx.getBaseURL() + WEOAuthConstants.getCallbackURL(serviceProviderName, isInstalledApp);
        String userId = isInstalledApp ? "system" : this.getCurrentUsername();
        HttpResponse response = flow.newTokenRequest(code).setRedirectUri(redirectUri).executeUnparsed();
        TokenResponse tokenResponse = (TokenResponse)response.parseAs(TokenResponse.class);
        Credential credential = flow.createAndStoreCredential(tokenResponse, userId);
        return this.getView("index");
    }

    protected static NuxeoOAuth2ServiceProvider getServiceProvider(String serviceName) throws Exception {
        OAuth2ServiceProviderRegistry registry;
        try {
            registry = (OAuth2ServiceProviderRegistry)Framework.getService(OAuth2ServiceProviderRegistry.class);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not find OAuthServiceProviderRegistry service.", e);
        }
        NuxeoOAuth2ServiceProvider nuxeoServiceProvider = registry.getProvider(serviceName);
        return nuxeoServiceProvider;
    }

    protected String getCurrentUsername() {
        return this.ctx.getPrincipal().getName();
    }
}

