/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.task.web;

import java.util.ArrayList;
import java.util.List;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.core.Events;
import org.jboss.seam.faces.FacesMessages;
import org.jboss.seam.international.LocaleSelector;
import org.jboss.seam.international.StatusMessage;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.platform.task.Task;
import org.nuxeo.ecm.platform.task.TaskService;
import org.nuxeo.ecm.platform.task.core.helpers.TaskActorsHelper;
import org.nuxeo.ecm.platform.task.dashboard.DashBoardItem;
import org.nuxeo.ecm.platform.task.dashboard.DashBoardItemImpl;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.platform.ui.web.invalidations.AutomaticDocumentBasedInvalidation;
import org.nuxeo.ecm.platform.ui.web.invalidations.DocumentContextBoundActionBean;
import org.nuxeo.ecm.webapp.helpers.ResourcesAccessor;

@Name(value="taskActions")
@Scope(value=ScopeType.CONVERSATION)
@AutomaticDocumentBasedInvalidation
public class TaskActionsBean
extends DocumentContextBoundActionBean {
    private static final long serialVersionUID = 1L;
    @In(create=true, required=false)
    protected transient CoreSession documentManager;
    @In(create=true)
    protected transient TaskService taskService;
    @In(create=true)
    protected transient NavigationContext navigationContext;
    @In(create=true, required=false)
    protected FacesMessages facesMessages;
    @In(create=true)
    protected ResourcesAccessor resourcesAccessor;
    @In(create=true)
    protected transient LocaleSelector localeSelector;
    protected List<Task> tasks;
    protected List<DashBoardItem> items;
    protected String comment;

    @Factory(value="currentSingleTasks", scope=ScopeType.EVENT)
    public List<Task> getCurrentDocumentTasks() throws ClientException {
        if (this.tasks == null) {
            this.tasks = new ArrayList<Task>();
            DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
            if (currentDocument != null) {
                NuxeoPrincipal principal = (NuxeoPrincipal)this.documentManager.getPrincipal();
                ArrayList actors = new ArrayList();
                actors.addAll(TaskActorsHelper.getTaskActors((NuxeoPrincipal)principal));
                this.tasks = this.taskService.getTaskInstances(currentDocument, actors, true, this.documentManager);
            }
        }
        return this.tasks;
    }

    @Factory(value="currentDashBoardItems", scope=ScopeType.EVENT)
    public List<DashBoardItem> getCurrentDashBoardItems() throws ClientException {
        if (this.items == null) {
            this.items = new ArrayList<DashBoardItem>();
            for (Task task : this.getCurrentDocumentTasks()) {
                DashBoardItemImpl item = new DashBoardItemImpl(task, this.navigationContext.getCurrentDocument(), this.localeSelector.getLocale());
                this.items.add((DashBoardItem)item);
            }
        }
        return this.items;
    }

    @Factory(value="currentDashBoardItemsExceptPublishingTasks", scope=ScopeType.EVENT)
    public List<DashBoardItem> getCurrentDashBoardItemsExceptPublishingTasks() throws ClientException {
        if (this.items == null) {
            this.items = new ArrayList<DashBoardItem>();
            for (Task task : this.getCurrentDocumentTasks()) {
                String taskType = task.getVariable(Task.TaskVariableName.taskType.name());
                if ("publish_moderate".equals(taskType)) continue;
                DashBoardItemImpl item = new DashBoardItemImpl(task, this.navigationContext.getCurrentDocument(), this.localeSelector.getLocale());
                this.items.add((DashBoardItem)item);
            }
        }
        return this.items;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void acceptTask(Task task) throws ClientException {
        this.acceptTask(task, this.getComment());
        this.setComment(null);
    }

    public void acceptTask(Task task, String comment) throws ClientException {
        String seamEventName = this.taskService.acceptTask(this.documentManager, (NuxeoPrincipal)this.documentManager.getPrincipal(), task, comment);
        if (seamEventName != null) {
            Events.instance().raiseEvent(seamEventName, new Object[0]);
        }
    }

    public void rejectTask(Task task) throws ClientException {
        String userComment = this.getComment();
        if (userComment != null && !"".equals(userComment)) {
            this.rejectTask(task, userComment);
            this.setComment(null);
        } else {
            this.facesMessages.add(StatusMessage.Severity.ERROR, (String)this.resourcesAccessor.getMessages().get("label.review.task.enterComment"), new Object[0]);
        }
    }

    public void rejectTask(Task task, String comment) throws ClientException {
        String seamEventName = this.taskService.rejectTask(this.documentManager, (NuxeoPrincipal)this.documentManager.getPrincipal(), task, comment);
        if (seamEventName != null) {
            Events.instance().raiseEvent(seamEventName, new Object[0]);
        }
    }

    public void resetBeanCache(DocumentModel newCurrentDocumentModel) {
        this.resetCache();
    }

    @Observer(value={"workflowProcessEnded", "workflowNewProcessStarted", "workflowTaskStart", "workflowTaskStop", "workflowTaskRejected", "workflowUserAssignmentChanged", "workflowTaskReassigned", "workflowTaskDelegated", "workflowTaskCompleted", "workflowTaskRemoved", "workItemsListLoaded", "workflowTasksComputed", "workflowAbandoned", "workflowProcessCanceled", "domainSelectionChanged", "documentPublicationRejected", "documentPublished"}, create=false)
    @BypassInterceptors
    public void resetCache() {
        this.tasks = null;
        this.items = null;
    }
}

