/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.resource.mapping;

import javax.faces.application.ProjectStage;
import javax.faces.context.FacesContext;
import org.richfaces.application.CoreConfiguration;
import org.richfaces.application.configuration.ConfigurationServiceHelper;
import org.richfaces.resource.mapping.PropertiesMappingConfiguration;

enum ResourceLoadingOptimizationConfiguration {
    Packed(CoreConfiguration.Items.resourceOptimizationPackagingStages),
    Compressed(CoreConfiguration.Items.resourceOptimizationCompressionStages);

    private static final String STATIC_RESOURCES_FEATURE_NAME = "Static";
    private static final String FEATURES_PLACEHOLDER = "%Features%";
    private static final String DEFAULT_FEATURE_MAPPING_FILE = "META-INF/richfaces/optimizedResourcesMapping/%Features%.properties";
    private CoreConfiguration.Items associatedConfiguration;

    private ResourceLoadingOptimizationConfiguration(CoreConfiguration.Items associatedConfiguration) {
        this.associatedConfiguration = associatedConfiguration;
    }

    static String getResourceLoadingSpecificMappingFile() {
        return ResourceLoadingOptimizationConfiguration.format(DEFAULT_FEATURE_MAPPING_FILE, ResourceLoadingOptimizationConfiguration.getEnabledFeatures());
    }

    static boolean isEnabled() {
        return ConfigurationServiceHelper.getBooleanConfigurationValue(FacesContext.getCurrentInstance(), CoreConfiguration.Items.resourceOptimizationEnabled);
    }

    private boolean enabled() {
        String configuredPhases = PropertiesMappingConfiguration.getConfiguration(this.associatedConfiguration);
        if (configuredPhases == null) {
            return false;
        }
        ProjectStage projectStage = FacesContext.getCurrentInstance().getApplication().getProjectStage();
        return "All".equals(configuredPhases) || configuredPhases.matches("(^|.*,)" + projectStage.toString() + "($|,.*)");
    }

    private static String getEnabledFeatures() {
        StringBuffer affix = new StringBuffer();
        for (ResourceLoadingOptimizationConfiguration feature : ResourceLoadingOptimizationConfiguration.values()) {
            if (!feature.enabled()) continue;
            affix.append(feature.toString());
        }
        if (affix.length() == 0) {
            return STATIC_RESOURCES_FEATURE_NAME;
        }
        return affix.toString();
    }

    private static String format(String string, String message) {
        return string.replace(FEATURES_PLACEHOLDER, message);
    }
}

