/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.resource.external;

import java.lang.reflect.Method;
import java.util.Arrays;
import javax.faces.context.FacesContext;
import org.richfaces.log.Logger;
import org.richfaces.log.RichfacesLogger;
import org.richfaces.resource.ResourceKey;
import org.richfaces.resource.external.ResourceTracker;

public class ResourceTrackerForMyFaces
implements ResourceTracker {
    private static final Logger LOG = RichfacesLogger.RESOURCE.getLogger();
    private final Method isRenderedStylesheet;
    private final Method isRenderedScript;
    private final Method markStylesheetAsRendered;
    private final Method markScriptAsRendered;

    public ResourceTrackerForMyFaces(Class<?> resourceUtilsClass) {
        try {
            this.isRenderedStylesheet = resourceUtilsClass.getMethod("isRenderedStylesheet", FacesContext.class, String.class, String.class);
            this.isRenderedScript = resourceUtilsClass.getMethod("isRenderedScript", FacesContext.class, String.class, String.class);
            this.markStylesheetAsRendered = resourceUtilsClass.getMethod("markStylesheetAsRendered", FacesContext.class, String.class, String.class);
            this.markScriptAsRendered = resourceUtilsClass.getMethod("markScriptAsRendered", FacesContext.class, String.class, String.class);
        }
        catch (Exception e) {
            ResourceTrackerForMyFaces.handleException(e);
            throw new ExceptionInInitializerError(e);
        }
    }

    private static void handleException(Exception e) {
        LOG.error("error while delegating resource handling to myfaces impl", e);
    }

    @Override
    public boolean isResourceRenderered(FacesContext facesContext, ResourceKey resourceKey) {
        String mimeType = facesContext.getExternalContext().getMimeType(resourceKey.getResourceName());
        try {
            if (MimeType.STYLESHEET.contains(mimeType)) {
                return (Boolean)this.isRenderedStylesheet.invoke(null, facesContext, resourceKey.getLibraryName(), resourceKey.getResourceName());
            }
            if (MimeType.SCRIPT.contains(mimeType)) {
                return (Boolean)this.isRenderedScript.invoke(null, facesContext, resourceKey.getLibraryName(), resourceKey.getResourceName());
            }
        }
        catch (Exception e) {
            ResourceTrackerForMyFaces.handleException(e);
        }
        return false;
    }

    @Override
    public void markResourceRendered(FacesContext facesContext, ResourceKey resourceKey) {
        String mimeType = facesContext.getExternalContext().getMimeType(resourceKey.getResourceName());
        try {
            if (MimeType.STYLESHEET.contains(mimeType)) {
                this.markStylesheetAsRendered.invoke(null, facesContext, resourceKey.getLibraryName(), resourceKey.getResourceName());
            } else if (MimeType.SCRIPT.contains(mimeType)) {
                this.markScriptAsRendered.invoke(null, facesContext, resourceKey.getLibraryName(), resourceKey.getResourceName());
            }
        }
        catch (Exception e) {
            ResourceTrackerForMyFaces.handleException(e);
        }
    }

    private static enum MimeType {
        SCRIPT("application/javascript", "text/javascript"),
        STYLESHEET("text/css");

        private String[] types;

        private MimeType(String ... types) {
            this.types = types;
        }

        public boolean contains(String type) {
            return Arrays.asList(this.types).contains(type);
        }
    }
}

