/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.bindings.spi.browser;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import org.apache.chemistry.opencmis.client.bindings.spi.BindingSession;
import org.apache.chemistry.opencmis.client.bindings.spi.browser.AbstractBrowserBindingService;
import org.apache.chemistry.opencmis.client.bindings.spi.browser.ClientTypeCacheImpl;
import org.apache.chemistry.opencmis.client.bindings.spi.browser.FormDataWriter;
import org.apache.chemistry.opencmis.client.bindings.spi.http.Output;
import org.apache.chemistry.opencmis.client.bindings.spi.http.Response;
import org.apache.chemistry.opencmis.commons.data.Acl;
import org.apache.chemistry.opencmis.commons.data.AllowableActions;
import org.apache.chemistry.opencmis.commons.data.BulkUpdateObjectIdAndChangeToken;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.data.ExtensionsData;
import org.apache.chemistry.opencmis.commons.data.FailedToDeleteData;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.data.Properties;
import org.apache.chemistry.opencmis.commons.data.RenditionData;
import org.apache.chemistry.opencmis.commons.enums.IncludeRelationships;
import org.apache.chemistry.opencmis.commons.enums.UnfileObject;
import org.apache.chemistry.opencmis.commons.enums.VersioningState;
import org.apache.chemistry.opencmis.commons.exceptions.CmisConnectionException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.impl.CollectionsHelper;
import org.apache.chemistry.opencmis.commons.impl.IOUtils;
import org.apache.chemistry.opencmis.commons.impl.JSONConverter;
import org.apache.chemistry.opencmis.commons.impl.MimeHelper;
import org.apache.chemistry.opencmis.commons.impl.TypeCache;
import org.apache.chemistry.opencmis.commons.impl.UrlBuilder;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ContentStreamImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.FailedToDeleteDataImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PartialContentStreamImpl;
import org.apache.chemistry.opencmis.commons.spi.Holder;
import org.apache.chemistry.opencmis.commons.spi.ObjectService;

public class ObjectServiceImpl
extends AbstractBrowserBindingService
implements ObjectService {
    public ObjectServiceImpl(BindingSession session) {
        this.setSession(session);
    }

    public String createDocument(String repositoryId, Properties properties, String folderId, ContentStream contentStream, VersioningState versioningState, List<String> policies, Acl addAces, Acl removeAces, ExtensionsData extension) {
        UrlBuilder url = folderId != null ? this.getObjectUrl(repositoryId, folderId) : this.getRepositoryUrl(repositoryId);
        final FormDataWriter formData = new FormDataWriter("createDocument", contentStream);
        formData.addPropertiesParameters(properties, this.getDateTimeFormat());
        formData.addParameter("versioningState", versioningState);
        formData.addPoliciesParameters(policies);
        formData.addAddAcesParameters(addAces);
        formData.addRemoveAcesParameters(removeAces);
        formData.addSuccinctFlag(this.getSuccinct());
        Response resp = this.post(url, formData.getContentType(), new Output(){

            @Override
            public void write(OutputStream out) throws IOException {
                formData.write(out);
            }
        });
        Map<String, Object> json = this.parseObject(resp.getStream(), resp.getCharset());
        ClientTypeCacheImpl typeCache = new ClientTypeCacheImpl(repositoryId, this);
        ObjectData newObj = JSONConverter.convertObject(json, (TypeCache)typeCache);
        return newObj == null ? null : newObj.getId();
    }

    public String createDocumentFromSource(String repositoryId, String sourceId, Properties properties, String folderId, VersioningState versioningState, List<String> policies, Acl addAces, Acl removeAces, ExtensionsData extension) {
        UrlBuilder url = folderId != null ? this.getObjectUrl(repositoryId, folderId) : this.getRepositoryUrl(repositoryId);
        final FormDataWriter formData = new FormDataWriter("createDocumentFromSource");
        formData.addParameter("sourceId", sourceId);
        formData.addPropertiesParameters(properties, this.getDateTimeFormat());
        formData.addParameter("versioningState", versioningState);
        formData.addPoliciesParameters(policies);
        formData.addAddAcesParameters(addAces);
        formData.addRemoveAcesParameters(removeAces);
        formData.addSuccinctFlag(this.getSuccinct());
        Response resp = this.post(url, formData.getContentType(), new Output(){

            @Override
            public void write(OutputStream out) throws IOException {
                formData.write(out);
            }
        });
        Map<String, Object> json = this.parseObject(resp.getStream(), resp.getCharset());
        ClientTypeCacheImpl typeCache = new ClientTypeCacheImpl(repositoryId, this);
        ObjectData newObj = JSONConverter.convertObject(json, (TypeCache)typeCache);
        return newObj == null ? null : newObj.getId();
    }

    public String createFolder(String repositoryId, Properties properties, String folderId, List<String> policies, Acl addAces, Acl removeAces, ExtensionsData extension) {
        UrlBuilder url = this.getObjectUrl(repositoryId, folderId);
        final FormDataWriter formData = new FormDataWriter("createFolder");
        formData.addPropertiesParameters(properties, this.getDateTimeFormat());
        formData.addPoliciesParameters(policies);
        formData.addAddAcesParameters(addAces);
        formData.addRemoveAcesParameters(removeAces);
        formData.addSuccinctFlag(this.getSuccinct());
        Response resp = this.post(url, formData.getContentType(), new Output(){

            @Override
            public void write(OutputStream out) throws IOException {
                formData.write(out);
            }
        });
        Map<String, Object> json = this.parseObject(resp.getStream(), resp.getCharset());
        ClientTypeCacheImpl typeCache = new ClientTypeCacheImpl(repositoryId, this);
        ObjectData newObj = JSONConverter.convertObject(json, (TypeCache)typeCache);
        return newObj == null ? null : newObj.getId();
    }

    public String createRelationship(String repositoryId, Properties properties, List<String> policies, Acl addAces, Acl removeAces, ExtensionsData extension) {
        UrlBuilder url = this.getRepositoryUrl(repositoryId);
        final FormDataWriter formData = new FormDataWriter("createRelationship");
        formData.addPropertiesParameters(properties, this.getDateTimeFormat());
        formData.addPoliciesParameters(policies);
        formData.addAddAcesParameters(addAces);
        formData.addRemoveAcesParameters(removeAces);
        formData.addSuccinctFlag(this.getSuccinct());
        Response resp = this.post(url, formData.getContentType(), new Output(){

            @Override
            public void write(OutputStream out) throws IOException {
                formData.write(out);
            }
        });
        Map<String, Object> json = this.parseObject(resp.getStream(), resp.getCharset());
        ClientTypeCacheImpl typeCache = new ClientTypeCacheImpl(repositoryId, this);
        ObjectData newObj = JSONConverter.convertObject(json, (TypeCache)typeCache);
        return newObj == null ? null : newObj.getId();
    }

    public String createPolicy(String repositoryId, Properties properties, String folderId, List<String> policies, Acl addAces, Acl removeAces, ExtensionsData extension) {
        UrlBuilder url = folderId != null ? this.getObjectUrl(repositoryId, folderId) : this.getRepositoryUrl(repositoryId);
        final FormDataWriter formData = new FormDataWriter("createPolicy");
        formData.addPropertiesParameters(properties, this.getDateTimeFormat());
        formData.addPoliciesParameters(policies);
        formData.addAddAcesParameters(addAces);
        formData.addRemoveAcesParameters(removeAces);
        formData.addSuccinctFlag(this.getSuccinct());
        Response resp = this.post(url, formData.getContentType(), new Output(){

            @Override
            public void write(OutputStream out) throws IOException {
                formData.write(out);
            }
        });
        Map<String, Object> json = this.parseObject(resp.getStream(), resp.getCharset());
        ClientTypeCacheImpl typeCache = new ClientTypeCacheImpl(repositoryId, this);
        ObjectData newObj = JSONConverter.convertObject(json, (TypeCache)typeCache);
        return newObj == null ? null : newObj.getId();
    }

    public String createItem(String repositoryId, Properties properties, String folderId, List<String> policies, Acl addAces, Acl removeAces, ExtensionsData extension) {
        UrlBuilder url = folderId != null ? this.getObjectUrl(repositoryId, folderId) : this.getRepositoryUrl(repositoryId);
        final FormDataWriter formData = new FormDataWriter("createItem");
        formData.addPropertiesParameters(properties, this.getDateTimeFormat());
        formData.addPoliciesParameters(policies);
        formData.addAddAcesParameters(addAces);
        formData.addRemoveAcesParameters(removeAces);
        formData.addSuccinctFlag(this.getSuccinct());
        Response resp = this.post(url, formData.getContentType(), new Output(){

            @Override
            public void write(OutputStream out) throws IOException {
                formData.write(out);
            }
        });
        Map<String, Object> json = this.parseObject(resp.getStream(), resp.getCharset());
        ClientTypeCacheImpl typeCache = new ClientTypeCacheImpl(repositoryId, this);
        ObjectData newObj = JSONConverter.convertObject(json, (TypeCache)typeCache);
        return newObj == null ? null : newObj.getId();
    }

    public AllowableActions getAllowableActions(String repositoryId, String objectId, ExtensionsData extension) {
        UrlBuilder url = this.getObjectUrl(repositoryId, objectId, "allowableActions");
        Response resp = this.read(url);
        Map<String, Object> json = this.parseObject(resp.getStream(), resp.getCharset());
        return JSONConverter.convertAllowableActions(json);
    }

    public ObjectData getObject(String repositoryId, String objectId, String filter, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePolicyIds, Boolean includeAcl, ExtensionsData extension) {
        UrlBuilder url = this.getObjectUrl(repositoryId, objectId, "object");
        url.addParameter("filter", (Object)filter);
        url.addParameter("includeAllowableActions", (Object)includeAllowableActions);
        url.addParameter("includeRelationships", (Object)includeRelationships);
        url.addParameter("renditionFilter", (Object)renditionFilter);
        url.addParameter("includePolicyIds", (Object)includePolicyIds);
        url.addParameter("includeACL", (Object)includeAcl);
        url.addParameter("succinct", (Object)this.getSuccinctParameter());
        url.addParameter("dateTimeFormat", (Object)this.getDateTimeFormatParameter());
        Response resp = this.read(url);
        Map<String, Object> json = this.parseObject(resp.getStream(), resp.getCharset());
        ClientTypeCacheImpl typeCache = new ClientTypeCacheImpl(repositoryId, this);
        return JSONConverter.convertObject(json, (TypeCache)typeCache);
    }

    public ObjectData getObjectByPath(String repositoryId, String path, String filter, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePolicyIds, Boolean includeAcl, ExtensionsData extension) {
        UrlBuilder url = this.getPathUrl(repositoryId, path, "object");
        url.addParameter("filter", (Object)filter);
        url.addParameter("includeAllowableActions", (Object)includeAllowableActions);
        url.addParameter("includeRelationships", (Object)includeRelationships);
        url.addParameter("renditionFilter", (Object)renditionFilter);
        url.addParameter("includePolicyIds", (Object)includePolicyIds);
        url.addParameter("includeACL", (Object)includeAcl);
        url.addParameter("succinct", (Object)this.getSuccinctParameter());
        url.addParameter("dateTimeFormat", (Object)this.getDateTimeFormatParameter());
        Response resp = this.read(url);
        Map<String, Object> json = this.parseObject(resp.getStream(), resp.getCharset());
        ClientTypeCacheImpl typeCache = new ClientTypeCacheImpl(repositoryId, this);
        return JSONConverter.convertObject(json, (TypeCache)typeCache);
    }

    public Properties getProperties(String repositoryId, String objectId, String filter, ExtensionsData extension) {
        UrlBuilder url = this.getObjectUrl(repositoryId, objectId, "properties");
        url.addParameter("filter", (Object)filter);
        url.addParameter("succinct", (Object)this.getSuccinctParameter());
        url.addParameter("dateTimeFormat", (Object)this.getDateTimeFormatParameter());
        Response resp = this.read(url);
        Map<String, Object> json = this.parseObject(resp.getStream(), resp.getCharset());
        if (this.getSuccinct()) {
            ClientTypeCacheImpl typeCache = new ClientTypeCacheImpl(repositoryId, this);
            return JSONConverter.convertSuccinctProperties(json, null, (TypeCache)typeCache);
        }
        return JSONConverter.convertProperties(json, null);
    }

    public List<RenditionData> getRenditions(String repositoryId, String objectId, String renditionFilter, BigInteger maxItems, BigInteger skipCount, ExtensionsData extension) {
        UrlBuilder url = this.getObjectUrl(repositoryId, objectId, "renditions");
        url.addParameter("renditionFilter", (Object)renditionFilter);
        url.addParameter("maxItems", (Object)maxItems);
        url.addParameter("skipCount", (Object)skipCount);
        Response resp = this.read(url);
        List<Object> json = this.parseArray(resp.getStream(), resp.getCharset());
        return JSONConverter.convertRenditions(json);
    }

    public ContentStream getContentStream(String repositoryId, String objectId, String streamId, BigInteger offset, BigInteger length, ExtensionsData extension) {
        UrlBuilder url = this.getObjectUrl(repositoryId, objectId, "content");
        url.addParameter("streamId", (Object)streamId);
        Response resp = this.getHttpInvoker().invokeGET(url, this.getSession(), offset, length);
        if (resp.getResponseCode() != 200 && resp.getResponseCode() != 206) {
            throw this.convertStatusCode(resp.getResponseCode(), resp.getResponseMessage(), resp.getErrorContent(), null);
        }
        String filename = null;
        String contentDisposition = resp.getContentDisposition();
        if (contentDisposition != null) {
            filename = MimeHelper.decodeContentDispositionFilename((String)contentDisposition);
        }
        Object result = resp.getResponseCode() == 206 ? new PartialContentStreamImpl() : new ContentStreamImpl();
        result.setFileName(filename);
        result.setLength(resp.getContentLength());
        result.setMimeType(resp.getContentTypeHeader());
        result.setStream(resp.getStream());
        return result;
    }

    public void updateProperties(String repositoryId, Holder<String> objectId, Holder<String> changeToken, Properties properties, ExtensionsData extension) {
        if (objectId == null || objectId.getValue() == null || ((String)objectId.getValue()).length() == 0) {
            throw new CmisInvalidArgumentException("Object id must be set!");
        }
        UrlBuilder url = this.getObjectUrl(repositoryId, (String)objectId.getValue());
        final FormDataWriter formData = new FormDataWriter("update");
        formData.addPropertiesParameters(properties, this.getDateTimeFormat());
        formData.addParameter("changeToken", changeToken == null || this.getSession().get("org.apache.chemistry.opencmis.workaround.omitChangeTokens", false) ? null : (String)changeToken.getValue());
        formData.addSuccinctFlag(this.getSuccinct());
        Response resp = this.post(url, formData.getContentType(), new Output(){

            @Override
            public void write(OutputStream out) throws IOException {
                formData.write(out);
            }
        });
        Map<String, Object> json = this.parseObject(resp.getStream(), resp.getCharset());
        ClientTypeCacheImpl typeCache = new ClientTypeCacheImpl(repositoryId, this);
        ObjectData newObj = JSONConverter.convertObject(json, (TypeCache)typeCache);
        objectId.setValue((Object)(newObj == null ? null : newObj.getId()));
        if (changeToken != null && newObj != null && newObj.getProperties() != null) {
            Object ct = newObj.getProperties().getProperties().get("cmis:changeToken");
            changeToken.setValue((Object)(ct == null ? null : ct.toString()));
        }
    }

    public List<BulkUpdateObjectIdAndChangeToken> bulkUpdateProperties(String repositoryId, List<BulkUpdateObjectIdAndChangeToken> objectIdAndChangeToken, Properties properties, List<String> addSecondaryTypeIds, List<String> removeSecondaryTypeIds, ExtensionsData extension) {
        if (CollectionsHelper.isNullOrEmpty(objectIdAndChangeToken)) {
            throw new CmisInvalidArgumentException("Object ids must be set!");
        }
        UrlBuilder url = this.getRepositoryUrl(repositoryId);
        final FormDataWriter formData = new FormDataWriter("bulkUpdate");
        formData.addObjectIdsAndChangeTokens(objectIdAndChangeToken);
        formData.addPropertiesParameters(properties, this.getDateTimeFormat());
        formData.addSecondaryTypeIds(addSecondaryTypeIds);
        formData.removeSecondaryTypeIds(removeSecondaryTypeIds);
        Response resp = this.post(url, formData.getContentType(), new Output(){

            @Override
            public void write(OutputStream out) throws IOException {
                formData.write(out);
            }
        });
        List<Object> json = this.parseArray(resp.getStream(), resp.getCharset());
        return JSONConverter.convertBulkUpdate(json);
    }

    public void moveObject(String repositoryId, Holder<String> objectId, String targetFolderId, String sourceFolderId, ExtensionsData extension) {
        if (objectId == null || objectId.getValue() == null || ((String)objectId.getValue()).length() == 0) {
            throw new CmisInvalidArgumentException("Object id must be set!");
        }
        UrlBuilder url = this.getObjectUrl(repositoryId, (String)objectId.getValue());
        final FormDataWriter formData = new FormDataWriter("move");
        formData.addParameter("targetFolderId", targetFolderId);
        formData.addParameter("sourceFolderId", sourceFolderId);
        formData.addSuccinctFlag(this.getSuccinct());
        Response resp = this.post(url, formData.getContentType(), new Output(){

            @Override
            public void write(OutputStream out) throws IOException {
                formData.write(out);
            }
        });
        Map<String, Object> json = this.parseObject(resp.getStream(), resp.getCharset());
        ClientTypeCacheImpl typeCache = new ClientTypeCacheImpl(repositoryId, this);
        ObjectData newObj = JSONConverter.convertObject(json, (TypeCache)typeCache);
        objectId.setValue((Object)(newObj == null ? null : newObj.getId()));
    }

    public void deleteObject(String repositoryId, String objectId, Boolean allVersions, ExtensionsData extension) {
        UrlBuilder url = this.getObjectUrl(repositoryId, objectId);
        final FormDataWriter formData = new FormDataWriter("delete");
        formData.addParameter("allVersions", allVersions);
        this.postAndConsume(url, formData.getContentType(), new Output(){

            @Override
            public void write(OutputStream out) throws IOException {
                formData.write(out);
            }
        });
    }

    public FailedToDeleteData deleteTree(String repositoryId, String folderId, Boolean allVersions, UnfileObject unfileObjects, Boolean continueOnFailure, ExtensionsData extension) {
        UrlBuilder url = this.getObjectUrl(repositoryId, folderId);
        final FormDataWriter formData = new FormDataWriter("deleteTree");
        formData.addParameter("allVersions", allVersions);
        formData.addParameter("unfileObjects", unfileObjects);
        formData.addParameter("continueOnFailure", continueOnFailure);
        Response resp = this.post(url, formData.getContentType(), new Output(){

            @Override
            public void write(OutputStream out) throws IOException {
                formData.write(out);
            }
        });
        if (resp.hasResponseStream()) {
            try {
                InputStream responseStream = IOUtils.checkForBytes((InputStream)resp.getStream(), (int)8192);
                if (responseStream != null) {
                    Map<String, Object> json = this.parseObject(responseStream, resp.getCharset());
                    return JSONConverter.convertFailedToDelete(json);
                }
            }
            catch (IOException e) {
                throw new CmisConnectionException("Cannot read response!", (Throwable)e);
            }
        }
        return new FailedToDeleteDataImpl();
    }

    public void setContentStream(String repositoryId, Holder<String> objectId, Boolean overwriteFlag, Holder<String> changeToken, ContentStream contentStream, ExtensionsData extension) {
        if (objectId == null || objectId.getValue() == null || ((String)objectId.getValue()).length() == 0) {
            throw new CmisInvalidArgumentException("Object id must be set!");
        }
        UrlBuilder url = this.getObjectUrl(repositoryId, (String)objectId.getValue());
        final FormDataWriter formData = new FormDataWriter("setContent", contentStream);
        formData.addParameter("overwriteFlag", overwriteFlag);
        formData.addParameter("changeToken", changeToken == null || this.getSession().get("org.apache.chemistry.opencmis.workaround.omitChangeTokens", false) ? null : (String)changeToken.getValue());
        formData.addSuccinctFlag(this.getSuccinct());
        Response resp = this.post(url, formData.getContentType(), new Output(){

            @Override
            public void write(OutputStream out) throws IOException {
                formData.write(out);
            }
        });
        Map<String, Object> json = this.parseObject(resp.getStream(), resp.getCharset());
        ClientTypeCacheImpl typeCache = new ClientTypeCacheImpl(repositoryId, this);
        ObjectData newObj = JSONConverter.convertObject(json, (TypeCache)typeCache);
        objectId.setValue((Object)(newObj == null ? null : newObj.getId()));
        if (changeToken != null && newObj != null && newObj.getProperties() != null) {
            Object ct = newObj.getProperties().getProperties().get("cmis:changeToken");
            changeToken.setValue((Object)(ct == null ? null : ct.toString()));
        }
    }

    public void appendContentStream(String repositoryId, Holder<String> objectId, Holder<String> changeToken, ContentStream contentStream, boolean isLastChunk, ExtensionsData extension) {
        if (objectId == null || objectId.getValue() == null || ((String)objectId.getValue()).length() == 0) {
            throw new CmisInvalidArgumentException("Object id must be set!");
        }
        UrlBuilder url = this.getObjectUrl(repositoryId, (String)objectId.getValue());
        final FormDataWriter formData = new FormDataWriter("appendContent", contentStream);
        formData.addParameter("isLastChunk", isLastChunk);
        formData.addParameter("changeToken", changeToken == null || this.getSession().get("org.apache.chemistry.opencmis.workaround.omitChangeTokens", false) ? null : (String)changeToken.getValue());
        formData.addSuccinctFlag(this.getSuccinct());
        Response resp = this.post(url, formData.getContentType(), new Output(){

            @Override
            public void write(OutputStream out) throws IOException {
                formData.write(out);
            }
        });
        Map<String, Object> json = this.parseObject(resp.getStream(), resp.getCharset());
        ClientTypeCacheImpl typeCache = new ClientTypeCacheImpl(repositoryId, this);
        ObjectData newObj = JSONConverter.convertObject(json, (TypeCache)typeCache);
        objectId.setValue((Object)(newObj == null ? null : newObj.getId()));
        if (changeToken != null && newObj != null && newObj.getProperties() != null) {
            Object ct = newObj.getProperties().getProperties().get("cmis:changeToken");
            changeToken.setValue((Object)(ct == null ? null : ct.toString()));
        }
    }

    public void deleteContentStream(String repositoryId, Holder<String> objectId, Holder<String> changeToken, ExtensionsData extension) {
        if (objectId == null || objectId.getValue() == null || ((String)objectId.getValue()).length() == 0) {
            throw new CmisInvalidArgumentException("Object id must be set!");
        }
        UrlBuilder url = this.getObjectUrl(repositoryId, (String)objectId.getValue());
        final FormDataWriter formData = new FormDataWriter("deleteContent");
        formData.addParameter("changeToken", changeToken == null || this.getSession().get("org.apache.chemistry.opencmis.workaround.omitChangeTokens", false) ? null : (String)changeToken.getValue());
        formData.addSuccinctFlag(this.getSuccinct());
        Response resp = this.post(url, formData.getContentType(), new Output(){

            @Override
            public void write(OutputStream out) throws IOException {
                formData.write(out);
            }
        });
        Map<String, Object> json = this.parseObject(resp.getStream(), resp.getCharset());
        ClientTypeCacheImpl typeCache = new ClientTypeCacheImpl(repositoryId, this);
        ObjectData newObj = JSONConverter.convertObject(json, (TypeCache)typeCache);
        objectId.setValue((Object)(newObj == null ? null : newObj.getId()));
        if (changeToken != null && newObj != null && newObj.getProperties() != null) {
            Object ct = newObj.getProperties().getProperties().get("cmis:changeToken");
            changeToken.setValue((Object)(ct == null ? null : ct.toString()));
        }
    }
}

