/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.pdf.ui;

import com.lowagie.text.html.simpleparser.HTMLWorker;
import com.lowagie.text.html.simpleparser.StyleSheet;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.ValueHolder;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import org.jboss.seam.pdf.ui.ITextComponent;
import org.jboss.seam.ui.util.JSF;

public class UIHtmlText
extends ITextComponent
implements ValueHolder {
    private Converter converter;
    private Object localValue;

    @Override
    public boolean getRendersChildren() {
        return true;
    }

    @Override
    public void encodeChildren(FacesContext context) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        StringWriter stringWriter = new StringWriter();
        ResponseWriter cachingResponseWriter = writer.cloneWithWriter((Writer)stringWriter);
        context.setResponseWriter(cachingResponseWriter);
        JSF.renderChildren((FacesContext)context, (UIComponent)this);
        context.setResponseWriter(writer);
        String output = stringWriter.getBuffer().toString();
        this.addFromHtml(output);
    }

    @Override
    public void encodeEnd(FacesContext context) throws IOException {
        Object value = this.getValue();
        if (value != null) {
            this.addFromHtml(this.convert(context, value));
        }
        super.encodeEnd(context);
    }

    private void addFromHtml(String html) throws IOException {
        for (Object o : HTMLWorker.parseToList((Reader)new StringReader(html), (StyleSheet)this.getStyle())) {
            this.addToITextParent(o);
        }
    }

    private StyleSheet getStyle() {
        StyleSheet styles = new StyleSheet();
        styles.loadTagStyle("body", "leading", "16,0");
        return styles;
    }

    protected String convert(FacesContext context, Object value) {
        Converter myConverter = this.converterForValue(context, value);
        if (myConverter != null) {
            return myConverter.getAsString(context, (UIComponent)this, value);
        }
        if (value != null) {
            return value.toString();
        }
        return "";
    }

    protected Converter converterForValue(FacesContext ctx, Object value) {
        if (this.converter != null) {
            return this.converter;
        }
        if (value != null) {
            try {
                return ctx.getApplication().createConverter(value.getClass());
            }
            catch (FacesException facesException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public void createITextObject(FacesContext context) {
    }

    @Override
    public Object getITextObject() {
        return null;
    }

    @Override
    public void removeITextObject() {
    }

    @Override
    public void handleAdd(Object other) {
        throw new RuntimeException("illegal child element");
    }

    public Converter getConverter() {
        return this.converter;
    }

    public void setConverter(Converter converter) {
        this.converter = converter;
    }

    public Object getValue() {
        return this.valueBinding(FacesContext.getCurrentInstance(), "value", this.localValue);
    }

    public void setValue(Object value) {
        this.localValue = value;
    }

    public Object getLocalValue() {
        return this.localValue;
    }
}

