/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.test;

import org.apache.log4j.Logger;
import org.nuxeo.ecm.core.repository.RepositoryFactory;
import org.nuxeo.ecm.core.storage.sql.ra.PoolingRepositoryFactory;
import org.nuxeo.ecm.core.test.annotations.Granularity;
import org.nuxeo.ecm.core.test.annotations.RepositoryConfig;
import org.nuxeo.ecm.core.test.annotations.TransactionalConfig;
import org.nuxeo.runtime.test.runner.ContainerFeature;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.transaction.TransactionHelper;

@RepositoryConfig(cleanup=Granularity.METHOD, repositoryFactoryClass=PoolingRepositoryFactory.class)
public class TransactionalFeature
extends ContainerFeature {
    protected TransactionalConfig config;
    protected String autoactivationValue;
    protected boolean nsOwner;
    protected boolean txStarted;
    protected Class<? extends RepositoryFactory> defaultFactory;

    public void initialize(FeaturesRunner runner) throws Exception {
        this.config = (TransactionalConfig)runner.getConfig(TransactionalConfig.class);
    }

    public void beforeSetup(FeaturesRunner runner) throws Exception {
        if (!this.config.autoStart()) {
            return;
        }
        this.txStarted = TransactionHelper.startTransaction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterTeardown(FeaturesRunner runner) throws Exception {
        if (!this.txStarted) {
            if (TransactionHelper.isTransactionActive()) {
                try {
                    TransactionHelper.setTransactionRollbackOnly();
                    TransactionHelper.commitOrRollbackTransaction();
                }
                finally {
                    Logger.getLogger(TransactionalFeature.class).warn((Object)"Committing a transaction for your, please do it yourself");
                }
            }
            return;
        }
        TransactionHelper.commitOrRollbackTransaction();
    }
}

