/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.test;

import com.google.inject.Binder;
import com.google.inject.Provider;
import com.google.inject.Scopes;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.runners.model.FrameworkMethod;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.event.EventService;
import org.nuxeo.ecm.core.test.CoreFeature;
import org.nuxeo.ecm.core.test.RepositorySettings;
import org.nuxeo.ecm.core.test.annotations.BackendType;
import org.nuxeo.ecm.core.test.annotations.Granularity;
import org.nuxeo.ecm.core.test.annotations.RepositoryConfig;
import org.nuxeo.ecm.core.test.annotations.RepositoryConfigs;
import org.nuxeo.ecm.core.test.annotations.RepositoryInit;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.test.runner.Deploy;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.RuntimeFeature;
import org.nuxeo.runtime.test.runner.SimpleFeature;

@Deploy(value={"org.nuxeo.ecm.core.schema", "org.nuxeo.ecm.core.query", "org.nuxeo.ecm.core.api", "org.nuxeo.ecm.core.event", "org.nuxeo.ecm.core", "org.nuxeo.ecm.core.convert", "org.nuxeo.ecm.core.storage.sql", "org.nuxeo.ecm.core.storage.sql.test"})
@Features(value={RuntimeFeature.class})
public class MultiRepositoriesCoreFeature
extends SimpleFeature {
    private static final Log log = LogFactory.getLog(CoreFeature.class);
    private final Map<String, RepositorySettings> repositories = new HashMap<String, RepositorySettings>();

    public RepositorySettings getRepository(String name) {
        return this.repositories.get(name);
    }

    public BackendType getBackendType(String name) {
        return this.repositories.get(name).getBackendType();
    }

    protected void setupRepos(FeaturesRunner runner) {
        RepositoryConfigs configs = (RepositoryConfigs)runner.getDescription().getAnnotation(RepositoryConfigs.class);
        if (configs == null) {
            RepositorySettings repo = new RepositorySettings(runner);
            this.repositories.put(repo.repositoryName, repo);
        } else {
            for (RepositoryConfig config : configs.value()) {
                RepositorySettings repository = new RepositorySettings(runner, config);
                this.repositories.put(repository.repositoryName, repository);
            }
        }
    }

    public void initialize(FeaturesRunner runner) throws Exception {
        this.setupRepos(runner);
    }

    public void start(FeaturesRunner runner) throws Exception {
        for (RepositorySettings repository : this.repositories.values()) {
            repository.initialize();
        }
    }

    public void configure(FeaturesRunner runner, Binder binder) {
        for (RepositorySettings repository : this.repositories.values()) {
            binder.bind(RepositorySettings.class).annotatedWith((Annotation)Names.named((String)repository.repositoryName)).toInstance((Object)repository);
            binder.bind(CoreSession.class).annotatedWith((Annotation)Names.named((String)repository.repositoryName)).toProvider((Provider)repository).in(Scopes.SINGLETON);
        }
    }

    public void beforeRun(FeaturesRunner runner) throws Exception {
        for (RepositorySettings repository : this.repositories.values()) {
            this.initializeSession(runner, repository);
        }
    }

    public void afterRun(FeaturesRunner runner) throws Exception {
        ((EventService)Framework.getService(EventService.class)).waitForAsyncCompletion();
        for (RepositorySettings repository : this.repositories.values()) {
            repository.shutdown();
        }
    }

    public void afterMethodRun(FeaturesRunner runner, FrameworkMethod method, Object test) throws Exception {
        for (RepositorySettings repository : this.repositories.values()) {
            if (repository.getGranularity() != Granularity.METHOD) continue;
            this.cleanupSession(runner, repository);
        }
    }

    protected void cleanupSession(FeaturesRunner runner, RepositorySettings repository) {
        CoreSession session = (CoreSession)runner.getInjector().getInstance(CoreSession.class);
        try {
            session.removeChildren((DocumentRef)new PathRef("/"));
        }
        catch (ClientException e) {
            log.error((Object)"Unable to reset repository", (Throwable)e);
        }
        this.initializeSession(runner, repository);
    }

    protected void initializeSession(FeaturesRunner runner, RepositorySettings repository) {
        CoreSession session = repository.get();
        RepositoryInit initializer = repository.getInitializer();
        if (initializer == null) {
            return;
        }
        try {
            initializer.populate(session);
            session.save();
        }
        catch (ClientException e) {
            throw new RuntimeException("Cannot populate repository", e);
        }
    }

    public void setRepositorySettings(RepositorySettings settings) {
        this.repositories.clear();
        this.repositories.put(settings.repositoryName, settings);
    }
}

