/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql;

import org.nuxeo.common.Environment;
import org.nuxeo.ecm.core.storage.sql.DatabaseH2;
import org.nuxeo.ecm.core.storage.sql.DatabaseHelper;
import org.nuxeo.ecm.core.storage.sql.DatabasePostgreSQL;
import org.nuxeo.ecm.core.storage.sql.SQLRepositoryTestCase;
import org.nuxeo.ecm.core.storage.sql.ra.PoolingRepositoryFactory;
import org.nuxeo.runtime.datasource.ConnectionHelper;
import org.nuxeo.runtime.transaction.TransactionHelper;

public abstract class TXSQLRepositoryTestCase
extends SQLRepositoryTestCase {
    @Override
    public void setUp() throws Exception {
        super.setUp();
        Environment.getDefault().setHostApplicationName("NXServer");
        this.fireFrameworkStarted();
        TransactionHelper.startTransaction();
        this.openSession();
    }

    protected void setUpContainer() throws Exception {
    }

    @Override
    protected void deployRepositoryContrib() throws Exception {
        DatabaseHelper.setRepositoryFactory(PoolingRepositoryFactory.class);
        super.deployRepositoryContrib();
        this.deployBundle("org.nuxeo.runtime.jtajca");
    }

    protected boolean hasPoolingConfig() {
        return this.database instanceof DatabaseH2 || this.database instanceof DatabasePostgreSQL;
    }

    protected boolean useSingleConnectionMode() {
        return ConnectionHelper.useSingleConnection((String)ConnectionHelper.getPseudoDataSourceNameForRepository((String)this.database.repositoryName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tearDown() throws Exception {
        try {
            if (this.session != null) {
                this.session.cancel();
                this.closeSession();
            }
            if (TransactionHelper.isTransactionActiveOrMarkedRollback()) {
                TransactionHelper.setTransactionRollbackOnly();
                TransactionHelper.commitOrRollbackTransaction();
            }
        }
        finally {
            super.tearDown();
        }
    }
}

