/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.event.EventService;
import org.nuxeo.ecm.core.storage.sql.DatabaseHelper;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.datasource.ConnectionHelper;
import org.nuxeo.runtime.test.NXRuntimeTestCase;

public abstract class SQLRepositoryTestCase
extends NXRuntimeTestCase {
    private static final Log log = LogFactory.getLog(SQLRepositoryTestCase.class);
    @Deprecated
    public static final String REPOSITORY_NAME = DatabaseHelper.DATABASE.repositoryName;
    public CoreSession session;
    protected int initialOpenSessions;
    protected int initialSingleConnections;
    public DatabaseHelper database = DatabaseHelper.DATABASE;

    public SQLRepositoryTestCase() {
    }

    public SQLRepositoryTestCase(String name) {
        super(name);
    }

    @Before
    public void setUp() throws Exception {
        this.initialOpenSessions = CoreInstance.getInstance().getNumberOfSessions();
        this.initialSingleConnections = ConnectionHelper.countConnectionReferences();
        super.setUp();
        this.deployBundle("org.nuxeo.runtime.management");
        this.deployBundle("org.nuxeo.ecm.core.schema");
        this.deployBundle("org.nuxeo.ecm.core.api");
        this.deployBundle("org.nuxeo.ecm.core");
        this.deployBundle("org.nuxeo.ecm.core.event");
        this.deployBundle("org.nuxeo.ecm.core.storage");
        this.deployBundle("org.nuxeo.ecm.core.storage.sql");
        this.database.setUp();
        this.deployRepositoryContrib();
    }

    protected void deployRepositoryContrib() throws Exception {
        this.deployContrib("org.nuxeo.ecm.core.storage.sql.test", this.database.getDeploymentContrib());
    }

    @After
    public void tearDown() throws Exception {
        int finalSingleConnections;
        int leakedSingleConnections;
        this.waitForAsyncCompletion();
        super.tearDown();
        CoreInstance core = CoreInstance.getInstance();
        int finalOpenSessions = core.getNumberOfSessions();
        int leakedOpenSessions = finalOpenSessions - this.initialOpenSessions;
        if (leakedOpenSessions != 0) {
            log.error((Object)String.format("There are %s open session(s) at tear down; it seems the test leaked %s session(s).", finalOpenSessions, leakedOpenSessions));
            for (CoreInstance.RegistrationInfo info : core.getRegistrationInfos()) {
                log.warn((Object)"Leaking session", (Throwable)info);
            }
        }
        if ((leakedSingleConnections = (finalSingleConnections = ConnectionHelper.countConnectionReferences()) - this.initialSingleConnections) > 0) {
            log.error((Object)String.format("There are %s single datasource connection(s) open at tear down; the test leaked %s connection(s).", finalSingleConnections, leakedSingleConnections));
        }
        ConnectionHelper.clearConnectionReferences();
    }

    public void waitForAsyncCompletion() {
        ((EventService)Framework.getLocalService(EventService.class)).waitForAsyncCompletion();
    }

    public void waitForFulltextIndexing() {
        this.waitForAsyncCompletion();
        DatabaseHelper.DATABASE.sleepForFulltext();
    }

    public void openSession() throws ClientException {
        if (this.session != null) {
            log.warn((Object)"Closing session for you");
            this.closeSession();
        }
        this.session = this.openSessionAs("Administrator");
        Assert.assertNotNull((Object)this.session);
    }

    public CoreSession openSessionAs(String username) throws ClientException {
        return CoreInstance.openCoreSession((String)this.database.repositoryName, (String)username);
    }

    public CoreSession openSessionAs(NuxeoPrincipal principal) throws ClientException {
        return CoreInstance.openCoreSession((String)this.database.repositoryName, (NuxeoPrincipal)principal);
    }

    public void closeSession() {
        this.closeSession(this.session);
        this.session = null;
    }

    public void closeSession(CoreSession session) {
        if (session != null) {
            session.close();
        }
    }
}

