/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.css.decl.visit;

import com.phloc.css.decl.CSSDeclaration;
import com.phloc.css.decl.CSSExpression;
import com.phloc.css.decl.CSSExpressionMemberTermURI;
import com.phloc.css.decl.CSSFontFaceRule;
import com.phloc.css.decl.CSSImportRule;
import com.phloc.css.decl.CSSKeyframesRule;
import com.phloc.css.decl.CSSMediaRule;
import com.phloc.css.decl.CSSPageRule;
import com.phloc.css.decl.CSSStyleRule;
import com.phloc.css.decl.ICSSExpressionMember;
import com.phloc.css.decl.ICSSTopLevelRule;
import com.phloc.css.decl.visit.DefaultCSSVisitor;
import com.phloc.css.decl.visit.ICSSUrlVisitor;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class CSSVisitorForUrl
extends DefaultCSSVisitor {
    private final ICSSUrlVisitor m_aVisitor;
    private ICSSTopLevelRule m_aTopLevelRule;

    public CSSVisitorForUrl(@Nonnull ICSSUrlVisitor iCSSUrlVisitor) {
        if (iCSSUrlVisitor == null) {
            throw new NullPointerException("visitor");
        }
        this.m_aVisitor = iCSSUrlVisitor;
    }

    @Override
    public void begin() {
        this.m_aVisitor.begin();
    }

    @Override
    public void onImport(@Nonnull CSSImportRule cSSImportRule) {
        this.m_aVisitor.onImport(cSSImportRule);
    }

    @Override
    public void onDeclaration(@Nonnull CSSDeclaration cSSDeclaration) {
        CSSExpression cSSExpression = cSSDeclaration.getExpression();
        for (ICSSExpressionMember iCSSExpressionMember : cSSExpression.getAllMembers()) {
            if (!(iCSSExpressionMember instanceof CSSExpressionMemberTermURI)) continue;
            CSSExpressionMemberTermURI cSSExpressionMemberTermURI = (CSSExpressionMemberTermURI)iCSSExpressionMember;
            this.m_aVisitor.onUrlDeclaration(this.m_aTopLevelRule, cSSDeclaration, cSSExpressionMemberTermURI);
        }
    }

    @Override
    public void onBeginStyleRule(@Nonnull CSSStyleRule cSSStyleRule) {
        this.m_aTopLevelRule = cSSStyleRule;
    }

    @Override
    public void onEndStyleRule(@Nonnull CSSStyleRule cSSStyleRule) {
        this.m_aTopLevelRule = null;
    }

    @Override
    public void onBeginPageRule(@Nonnull CSSPageRule cSSPageRule) {
        this.m_aTopLevelRule = cSSPageRule;
    }

    @Override
    public void onEndPageRule(@Nonnull CSSPageRule cSSPageRule) {
        this.m_aTopLevelRule = null;
    }

    @Override
    public void onBeginFontFaceRule(@Nonnull CSSFontFaceRule cSSFontFaceRule) {
        this.m_aTopLevelRule = cSSFontFaceRule;
    }

    @Override
    public void onEndFontFaceRule(@Nonnull CSSFontFaceRule cSSFontFaceRule) {
        this.m_aTopLevelRule = null;
    }

    @Override
    public void onBeginMediaRule(@Nonnull CSSMediaRule cSSMediaRule) {
        this.m_aTopLevelRule = cSSMediaRule;
    }

    @Override
    public void onEndMediaRule(@Nonnull CSSMediaRule cSSMediaRule) {
        this.m_aTopLevelRule = null;
    }

    @Override
    public void onBeginKeyframesRule(@Nonnull CSSKeyframesRule cSSKeyframesRule) {
        this.m_aTopLevelRule = cSSKeyframesRule;
    }

    @Override
    public void onEndKeyframesRule(@Nonnull CSSKeyframesRule cSSKeyframesRule) {
        this.m_aTopLevelRule = null;
    }

    @Override
    public void end() {
        this.m_aVisitor.end();
    }
}

