/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.css.decl;

import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.state.EChange;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.css.ICSSWriterSettings;
import com.phloc.css.decl.CSSDeclaration;
import com.phloc.css.decl.CSSDeclarationContainer;
import com.phloc.css.decl.CSSSelector;
import com.phloc.css.decl.ICSSTopLevelRule;
import com.phloc.css.decl.IHasCSSDeclarations;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class CSSStyleRule
implements ICSSTopLevelRule,
IHasCSSDeclarations {
    private final List<CSSSelector> m_aSelectors = new ArrayList<CSSSelector>();
    private final CSSDeclarationContainer m_aDeclarations = new CSSDeclarationContainer();

    public boolean hasSelectors() {
        return !this.m_aSelectors.isEmpty();
    }

    @Nonnegative
    public int getSelectorCount() {
        return this.m_aSelectors.size();
    }

    public void addSelector(@Nonnull CSSSelector cSSSelector) {
        if (cSSSelector == null) {
            throw new NullPointerException("selector");
        }
        this.m_aSelectors.add(cSSSelector);
    }

    @Nonnull
    public EChange removeSelector(@Nonnull CSSSelector cSSSelector) {
        return EChange.valueOf((boolean)this.m_aSelectors.remove(cSSSelector));
    }

    @Nonnull
    public EChange removeSelector(@Nonnegative int n) {
        if (n < 0 || n >= this.m_aSelectors.size()) {
            return EChange.UNCHANGED;
        }
        this.m_aSelectors.remove(n);
        return EChange.CHANGED;
    }

    @Nullable
    public CSSSelector getSelectorAtIndex(@Nonnegative int n) {
        if (n < 0 || n >= this.m_aSelectors.size()) {
            return null;
        }
        return this.m_aSelectors.get(n);
    }

    @Nonnull
    @ReturnsMutableCopy
    public List<CSSSelector> getAllSelectors() {
        return ContainerHelper.newList(this.m_aSelectors);
    }

    @Override
    public void addDeclaration(@Nonnull CSSDeclaration cSSDeclaration) {
        this.m_aDeclarations.addDeclaration(cSSDeclaration);
    }

    @Override
    @Nonnull
    public EChange removeDeclaration(@Nonnull CSSDeclaration cSSDeclaration) {
        return this.m_aDeclarations.removeDeclaration(cSSDeclaration);
    }

    @Override
    @Nonnull
    public EChange removeDeclaration(@Nonnegative int n) {
        return this.m_aDeclarations.removeDeclaration(n);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public List<CSSDeclaration> getAllDeclarations() {
        return this.m_aDeclarations.getAllDeclarations();
    }

    @Override
    @Nullable
    public CSSDeclaration getDeclarationAtIndex(@Nonnegative int n) {
        return this.m_aDeclarations.getDeclarationAtIndex(n);
    }

    @Override
    public boolean hasDeclarations() {
        return this.m_aDeclarations.hasDeclarations();
    }

    @Override
    @Nonnegative
    public int getDeclarationCount() {
        return this.m_aDeclarations.getDeclarationCount();
    }

    @Nonnull
    public String getSelectorsAsCSSString(@Nonnull ICSSWriterSettings iCSSWriterSettings, @Nonnegative int n) {
        boolean bl = iCSSWriterSettings.isOptimizedOutput();
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl2 = true;
        for (CSSSelector cSSSelector : this.m_aSelectors) {
            if (bl2) {
                bl2 = false;
            } else {
                stringBuilder.append(bl ? "," : ",\n");
            }
            stringBuilder.append(cSSSelector.getAsCSSString(iCSSWriterSettings, n));
        }
        return stringBuilder.toString();
    }

    @Override
    @Nonnull
    public String getAsCSSString(@Nonnull ICSSWriterSettings iCSSWriterSettings, @Nonnegative int n) {
        if (iCSSWriterSettings.isRemoveUnnecessaryCode() && this.getDeclarationCount() == 0) {
            return "";
        }
        boolean bl = iCSSWriterSettings.isOptimizedOutput();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getSelectorsAsCSSString(iCSSWriterSettings, n));
        stringBuilder.append(this.m_aDeclarations.getAsCSSString(iCSSWriterSettings, n));
        if (!bl) {
            stringBuilder.append('\n');
        }
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof CSSStyleRule)) {
            return false;
        }
        CSSStyleRule cSSStyleRule = (CSSStyleRule)object;
        return ((Object)this.m_aSelectors).equals(cSSStyleRule.m_aSelectors) && this.m_aDeclarations.equals(cSSStyleRule.m_aDeclarations);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_aSelectors).append((Object)this.m_aDeclarations).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("selectors", this.m_aSelectors).append("declarations", (Object)this.m_aDeclarations).toString();
    }
}

