/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.css.decl;

import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.equals.EqualsUtils;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.string.StringHelper;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.css.ICSSWriterSettings;
import com.phloc.css.decl.CSSExpression;
import com.phloc.css.decl.ICSSExpressionMember;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class CSSExpressionMemberFunction
implements ICSSExpressionMember {
    private final String m_sFunctionName;
    private final CSSExpression m_aExpression;

    @Nonnull
    private static String _skipBrackets(@Nonnull String string) {
        String string2 = string.trim();
        if (string2.length() > 2 && string2.endsWith("()")) {
            return string2.substring(0, string2.length() - 2).trim();
        }
        return string2;
    }

    public CSSExpressionMemberFunction(@Nonnull @Nonempty String string) {
        this(string, null);
    }

    public CSSExpressionMemberFunction(@Nonnull @Nonempty String string, @Nullable CSSExpression cSSExpression) {
        if (StringHelper.hasNoText((CharSequence)string)) {
            throw new IllegalArgumentException("Empty function name is not allowed");
        }
        this.m_sFunctionName = CSSExpressionMemberFunction._skipBrackets(string);
        this.m_aExpression = cSSExpression;
    }

    @Nonnull
    @Nonempty
    public String getFunctionName() {
        return this.m_sFunctionName;
    }

    @Nullable
    public CSSExpression getExpression() {
        return this.m_aExpression;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsCSSString(@Nonnull ICSSWriterSettings iCSSWriterSettings, @Nonnegative int n) {
        if (this.m_aExpression == null) {
            return this.m_sFunctionName + "()";
        }
        return this.m_sFunctionName + "(" + this.m_aExpression.getAsCSSString(iCSSWriterSettings, n) + ")";
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof CSSExpressionMemberFunction)) {
            return false;
        }
        CSSExpressionMemberFunction cSSExpressionMemberFunction = (CSSExpressionMemberFunction)object;
        return this.m_sFunctionName.equals(cSSExpressionMemberFunction.m_sFunctionName) && EqualsUtils.equals((Object)this.m_aExpression, (Object)cSSExpressionMemberFunction.m_aExpression);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sFunctionName).append((Object)this.m_aExpression).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(null).append("funcName", (Object)this.m_sFunctionName).appendIfNotNull("expression", (Object)this.m_aExpression).toString();
    }
}

