/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.connectioncache.client;

import com.sun.grizzly.AbstractConnectorHandler;
import com.sun.grizzly.CallbackHandler;
import com.sun.grizzly.CallbackHandlerSelectionKeyAttachment;
import com.sun.grizzly.ConnectorHandler;
import com.sun.grizzly.Controller;
import com.sun.grizzly.DefaultCallbackHandler;
import com.sun.grizzly.IOEvent;
import com.sun.grizzly.NIOContext;
import com.sun.grizzly.SelectorHandler;
import com.sun.grizzly.async.AsyncQueueDataProcessor;
import com.sun.grizzly.async.AsyncQueueReadUnit;
import com.sun.grizzly.async.AsyncQueueWriteUnit;
import com.sun.grizzly.async.AsyncReadCallbackHandler;
import com.sun.grizzly.async.AsyncReadCondition;
import com.sun.grizzly.async.AsyncWriteCallbackHandler;
import com.sun.grizzly.async.ByteBufferCloner;
import com.sun.grizzly.connectioncache.client.CacheableConnectorHandlerPool;
import com.sun.grizzly.connectioncache.spi.transport.ContactInfo;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.util.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheableConnectorHandler
extends AbstractConnectorHandler<SelectorHandler, CallbackHandler> {
    private SocketAddress targetAddress;
    private CacheableConnectorHandlerPool parentPool;
    private ConnectorHandler underlyingConnectorHandler;
    private ConnectExecutor connectExecutor;

    public CacheableConnectorHandler(CacheableConnectorHandlerPool parentPool) {
        this.parentPool = parentPool;
        this.connectExecutor = new ConnectExecutor();
    }

    @Override
    public void connect(SocketAddress remoteAddress, CallbackHandler callbackHandler, SelectorHandler selectorHandler) throws IOException {
        this.connectExecutor.setParameters(remoteAddress, callbackHandler, selectorHandler);
        this.doConnect(remoteAddress);
    }

    @Override
    public void connect(SocketAddress remoteAddress, CallbackHandler callbackHandler) throws IOException {
        this.connectExecutor.setParameters(remoteAddress, callbackHandler);
        this.doConnect(remoteAddress);
    }

    @Override
    public void connect(SocketAddress remoteAddress) throws IOException {
        this.connectExecutor.setParameters(remoteAddress);
        this.doConnect(remoteAddress);
    }

    @Override
    public void connect(SocketAddress remoteAddress, SocketAddress localAddress, CallbackHandler callbackHandler, SelectorHandler selectorHandler) throws IOException {
        this.connectExecutor.setParameters(remoteAddress, localAddress, callbackHandler, selectorHandler);
        this.doConnect(remoteAddress);
    }

    @Override
    public void connect(SocketAddress remoteAddress, SocketAddress localAddress, CallbackHandler callbackHandler) throws IOException {
        this.connectExecutor.setParameters(remoteAddress, localAddress, callbackHandler);
        this.doConnect(remoteAddress);
    }

    @Override
    public void connect(SocketAddress remoteAddress, SocketAddress localAddress) throws IOException {
        this.connectExecutor.setParameters(remoteAddress, localAddress);
        this.doConnect(remoteAddress);
    }

    public void release(int expectedResponseCount) {
        this.parentPool.getOutboundConnectionCache().release(this.underlyingConnectorHandler, expectedResponseCount);
    }

    public void responseReceived() {
        this.parentPool.getOutboundConnectionCache().responseReceived(this.underlyingConnectorHandler);
    }

    private void doConnect(SocketAddress targetAddress) throws IOException {
        this.targetAddress = targetAddress;
        this.callbackHandler = this.connectExecutor.callbackHandler;
        if (this.callbackHandler == null) {
            this.callbackHandler = new DefaultCallbackHandler(this);
        }
        this.underlyingConnectorHandler = this.parentPool.getOutboundConnectionCache().get(new CacheableConnectorInfo(this.parentPool, this.connectExecutor, this.protocol, targetAddress), this.parentPool.getConnectionFinder());
        if (!this.connectExecutor.wasCalled()) {
            this.underlyingConnectorHandler.setCallbackHandler(this.callbackHandler);
            this.notifyCallbackHandlerPseudoConnect();
        }
    }

    @Override
    public void close() throws IOException {
        this.parentPool.getOutboundConnectionCache().release(this.underlyingConnectorHandler, 0);
    }

    @Override
    public long read(ByteBuffer byteBuffer, boolean blocking) throws IOException {
        return this.underlyingConnectorHandler.read(byteBuffer, blocking);
    }

    @Override
    public long write(ByteBuffer byteBuffer, boolean blocking) throws IOException {
        return this.underlyingConnectorHandler.write(byteBuffer, blocking);
    }

    @Override
    public void finishConnect(SelectionKey key) {
        if (this.connectExecutor.wasCalled()) {
            try {
                this.underlyingConnectorHandler.finishConnect(key);
            }
            catch (IOException ex) {
                Controller.logger().severe(ex.getMessage());
            }
        }
    }

    @Override
    public boolean isConnected() {
        return this.underlyingConnectorHandler != null && this.underlyingConnectorHandler.isConnected();
    }

    public ConnectorHandler getUnderlyingConnectorHandler() {
        return this.underlyingConnectorHandler;
    }

    private void notifyCallbackHandlerPseudoConnect() throws ClosedChannelException {
        Object underlyingSelectorHandler = this.underlyingConnectorHandler.getSelectorHandler();
        SelectionKey key = underlyingSelectorHandler.keyFor(this.underlyingConnectorHandler.getUnderlyingChannel());
        assert (key != null);
        NIOContext context = (NIOContext)this.parentPool.getController().pollContext();
        context.setSelectionKey(key);
        context.configureOpType(key);
        context.setSelectorHandler((SelectorHandler)this.underlyingConnectorHandler.getSelectorHandler());
        key.attach(new CallbackHandlerSelectionKeyAttachment(this.callbackHandler));
        this.callbackHandler.onConnect(new IOEvent.DefaultIOEvent<NIOContext>(context));
    }

    @Override
    public Future<AsyncQueueWriteUnit> writeToAsyncQueue(ByteBuffer buffer) throws IOException {
        return this.underlyingConnectorHandler.writeToAsyncQueue(buffer);
    }

    @Override
    public Future<AsyncQueueWriteUnit> writeToAsyncQueue(ByteBuffer buffer, AsyncWriteCallbackHandler callbackHandler) throws IOException {
        return this.underlyingConnectorHandler.writeToAsyncQueue(buffer, callbackHandler);
    }

    @Override
    public Future<AsyncQueueWriteUnit> writeToAsyncQueue(ByteBuffer buffer, AsyncWriteCallbackHandler callbackHandler, AsyncQueueDataProcessor writePreProcessor) throws IOException {
        return this.underlyingConnectorHandler.writeToAsyncQueue(buffer, callbackHandler, writePreProcessor);
    }

    @Override
    public Future<AsyncQueueWriteUnit> writeToAsyncQueue(ByteBuffer buffer, AsyncWriteCallbackHandler callbackHandler, AsyncQueueDataProcessor writePreProcessor, ByteBufferCloner cloner) throws IOException {
        return this.underlyingConnectorHandler.writeToAsyncQueue(buffer, callbackHandler, writePreProcessor, cloner);
    }

    @Override
    public Future<AsyncQueueWriteUnit> writeToAsyncQueue(SocketAddress dstAddress, ByteBuffer buffer) throws IOException {
        return this.underlyingConnectorHandler.writeToAsyncQueue(dstAddress, buffer);
    }

    @Override
    public Future<AsyncQueueWriteUnit> writeToAsyncQueue(SocketAddress dstAddress, ByteBuffer buffer, AsyncWriteCallbackHandler callbackHandler) throws IOException {
        return this.underlyingConnectorHandler.writeToAsyncQueue(dstAddress, buffer, callbackHandler);
    }

    @Override
    public Future<AsyncQueueWriteUnit> writeToAsyncQueue(SocketAddress dstAddress, ByteBuffer buffer, AsyncWriteCallbackHandler callbackHandler, AsyncQueueDataProcessor writePreProcessor) throws IOException {
        return this.underlyingConnectorHandler.writeToAsyncQueue(dstAddress, buffer, callbackHandler, writePreProcessor);
    }

    @Override
    public Future<AsyncQueueWriteUnit> writeToAsyncQueue(SocketAddress dstAddress, ByteBuffer buffer, AsyncWriteCallbackHandler callbackHandler, AsyncQueueDataProcessor writePreProcessor, ByteBufferCloner cloner) throws IOException {
        return this.underlyingConnectorHandler.writeToAsyncQueue(dstAddress, buffer, callbackHandler, writePreProcessor, cloner);
    }

    @Override
    public Future<AsyncQueueReadUnit> readFromAsyncQueue(ByteBuffer buffer, AsyncReadCallbackHandler callbackHandler) throws IOException {
        return this.underlyingConnectorHandler.readFromAsyncQueue(buffer, callbackHandler);
    }

    @Override
    public Future<AsyncQueueReadUnit> readFromAsyncQueue(ByteBuffer buffer, AsyncReadCallbackHandler callbackHandler, AsyncReadCondition condition) throws IOException {
        return this.underlyingConnectorHandler.readFromAsyncQueue(buffer, callbackHandler, condition);
    }

    @Override
    public Future<AsyncQueueReadUnit> readFromAsyncQueue(ByteBuffer buffer, AsyncReadCallbackHandler callbackHandler, AsyncReadCondition condition, AsyncQueueDataProcessor readPostProcessor) throws IOException {
        return this.underlyingConnectorHandler.readFromAsyncQueue(buffer, callbackHandler, condition, readPostProcessor);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CacheableConnectorInfo
    implements ContactInfo<ConnectorHandler> {
        private SelectorHandler selectorHandler;
        private CacheableConnectorHandlerPool parentPool;
        private ConnectExecutor connectExecutor;
        private Controller.Protocol protocol;
        private SocketAddress targetAddress;

        public CacheableConnectorInfo(CacheableConnectorHandlerPool parentPool, ConnectExecutor connectExecutor, Controller.Protocol protocol, SocketAddress targetAddress) {
            this.parentPool = parentPool;
            this.connectExecutor = connectExecutor;
            this.protocol = protocol;
            this.targetAddress = targetAddress;
        }

        @Override
        public ConnectorHandler createConnection() throws IOException {
            Object connectorHandler = this.parentPool.getProtocolConnectorHandlerPool().acquireConnectorHandler(this.protocol);
            this.connectExecutor.setConnectorHandler((ConnectorHandler)connectorHandler);
            this.connectExecutor.invokeProtocolConnect();
            this.selectorHandler = connectorHandler.getSelectorHandler();
            return connectorHandler;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getClass().getName());
            sb.append(" targetAddress: ");
            sb.append(this.targetAddress);
            sb.append(" protocol: ");
            sb.append((Object)this.protocol);
            sb.append(" hashCode: ");
            sb.append(super.hashCode());
            return sb.toString();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CacheableConnectorInfo other = (CacheableConnectorInfo)obj;
            if (this.selectorHandler != null && other.selectorHandler != null && this.selectorHandler != other.selectorHandler && !this.selectorHandler.equals(other.selectorHandler)) {
                return false;
            }
            if (this.protocol != other.protocol) {
                return false;
            }
            return this.targetAddress == other.targetAddress || this.targetAddress != null && this.targetAddress.equals(other.targetAddress);
        }

        public int hashCode() {
            int hash = 3;
            hash = 47 * hash + (this.protocol != null ? this.protocol.hashCode() : 0);
            hash = 47 * hash + (this.targetAddress != null ? this.targetAddress.hashCode() : 0);
            return hash;
        }
    }

    private class ConnectExecutor {
        private int methodNumber;
        private SocketAddress remoteAddress;
        private SocketAddress localAddress;
        private SelectorHandler selectorHandler;
        private CallbackHandler callbackHandler;
        private boolean wasCalled;

        private ConnectExecutor() {
        }

        public void setConnectorHandler(ConnectorHandler connectorHandler) {
            CacheableConnectorHandler.this.underlyingConnectorHandler = connectorHandler;
        }

        public void setParameters(SocketAddress remoteAddress, CallbackHandler callbackHandler, SelectorHandler selectorHandler) {
            this.setParameters(remoteAddress, null, callbackHandler, selectorHandler);
            this.methodNumber = 1;
        }

        public void setParameters(SocketAddress remoteAddress, CallbackHandler callbackHandler) {
            this.setParameters(remoteAddress, null, callbackHandler);
            this.methodNumber = 2;
        }

        public void setParameters(SocketAddress remoteAddress) {
            this.setParameters(remoteAddress, (SocketAddress)null);
            this.methodNumber = 3;
        }

        public void setParameters(SocketAddress remoteAddress, SocketAddress localAddress, CallbackHandler callbackHandler, SelectorHandler selectorHandler) {
            this.wasCalled = false;
            this.remoteAddress = remoteAddress;
            this.localAddress = localAddress;
            this.callbackHandler = callbackHandler;
            this.selectorHandler = selectorHandler;
            this.methodNumber = 4;
        }

        public void setParameters(SocketAddress remoteAddress, SocketAddress localAddress, CallbackHandler callbackHandler) {
            this.setParameters(remoteAddress, localAddress, callbackHandler, null);
            this.methodNumber = 5;
        }

        public void setParameters(SocketAddress remoteAddress, SocketAddress localAddress) {
            this.setParameters(remoteAddress, localAddress, null);
            this.methodNumber = 6;
        }

        public boolean wasCalled() {
            return this.wasCalled;
        }

        public void invokeProtocolConnect() throws IOException {
            this.wasCalled = true;
            switch (this.methodNumber) {
                case 1: {
                    CacheableConnectorHandler.this.underlyingConnectorHandler.connect(this.remoteAddress, CacheableConnectorHandler.this.callbackHandler, this.selectorHandler);
                    break;
                }
                case 2: 
                case 3: {
                    CacheableConnectorHandler.this.underlyingConnectorHandler.connect(this.remoteAddress, CacheableConnectorHandler.this.callbackHandler);
                    break;
                }
                case 4: {
                    CacheableConnectorHandler.this.underlyingConnectorHandler.connect(this.remoteAddress, this.localAddress, CacheableConnectorHandler.this.callbackHandler, this.selectorHandler);
                    break;
                }
                case 5: 
                case 6: {
                    CacheableConnectorHandler.this.underlyingConnectorHandler.connect(this.remoteAddress, this.localAddress, CacheableConnectorHandler.this.callbackHandler);
                    break;
                }
                default: {
                    throw new IllegalStateException("Can not find appropriate connect method: " + this.methodNumber);
                }
            }
        }
    }
}

