/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.management.counters;

import java.util.Iterator;
import java.util.LinkedList;

public class CounterHistoryStack
implements Iterable<long[]> {
    protected final LinkedList<long[]> list = new LinkedList();
    protected final int maxSize;

    public CounterHistoryStack(int size) {
        this.maxSize = size;
    }

    public synchronized void push(long[] item) {
        this.list.push(item);
        if (this.list.size() > this.maxSize) {
            this.list.remove(this.list.size() - 1);
        }
    }

    @Override
    public Iterator<long[]> iterator() {
        return this.list.iterator();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (long[] entry : this) {
            sb.append(entry[0]);
            sb.append(" => ");
            sb.append(entry[1]);
            sb.append("\n");
        }
        return sb.toString();
    }

    public long[] get(int idx) {
        return this.list.get(idx);
    }

    public LinkedList<long[]> getAsList() {
        return this.list;
    }
}

