/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory.registry;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.directory.registry.DirectoryFactoryMapper;
import org.nuxeo.runtime.model.ContributionFragmentRegistry;

public class DirectoryFactoryMapperRegistry
extends ContributionFragmentRegistry<DirectoryFactoryMapper> {
    protected Map<String, List<String>> factoriesByDir = new HashMap<String, List<String>>();

    public String getContributionId(DirectoryFactoryMapper contrib) {
        return contrib.getDirectoryName();
    }

    public void contributionUpdated(String id, DirectoryFactoryMapper contrib, DirectoryFactoryMapper newOrigContrib) {
        this.factoriesByDir.put(id, contrib.getFactories());
    }

    public void contributionRemoved(String id, DirectoryFactoryMapper origContrib) {
        List<String> toRemove;
        List<String> factories = this.factoriesByDir.get(id);
        if (factories != null && (toRemove = origContrib.getFactories()) != null) {
            factories.removeAll(toRemove);
        }
    }

    public DirectoryFactoryMapper clone(DirectoryFactoryMapper orig) {
        return orig.clone();
    }

    public void merge(DirectoryFactoryMapper src, DirectoryFactoryMapper dst) {
        List<String> newFacts;
        List<String> oldFacts = dst.getFactories();
        ArrayList<String> updatedFacts = new ArrayList<String>();
        if (oldFacts != null) {
            updatedFacts.addAll(oldFacts);
        }
        if ((newFacts = src.getFactories()) != null) {
            for (String newFact : newFacts) {
                updatedFacts.remove(newFact);
                updatedFacts.add(0, newFact);
            }
        }
        dst.setFactories(updatedFacts);
    }

    public List<String> getFactoriesForDirectory(String name) {
        return this.factoriesByDir.get(name);
    }
}

