/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.impl.btree;

import javax.naming.NamingException;
import org.apache.directory.server.core.partition.impl.btree.BTreePartition;
import org.apache.directory.server.core.partition.impl.btree.Evaluator;
import org.apache.directory.server.core.partition.impl.btree.Index;
import org.apache.directory.server.core.partition.impl.btree.IndexRecord;
import org.apache.directory.shared.ldap.filter.ExprNode;
import org.apache.directory.shared.ldap.filter.ScopeNode;
import org.apache.directory.shared.ldap.message.DerefAliasesEnum;

public class ScopeEvaluator
implements Evaluator {
    private BTreePartition db;

    public ScopeEvaluator(BTreePartition db) {
        this.db = db;
    }

    public boolean evaluate(ExprNode node, IndexRecord record) throws NamingException {
        ScopeNode snode = (ScopeNode)node;
        switch (snode.getScope()) {
            case 0: {
                String dn = this.db.getEntryDn((Long)record.getEntryId());
                return dn.equals(snode.getBaseDn());
            }
            case 1: {
                return this.assertOneLevelScope(snode, (Long)record.getEntryId());
            }
            case 2: {
                return this.assertSubtreeScope(snode, (Long)record.getEntryId());
            }
        }
        throw new NamingException("Unrecognized search scope!");
    }

    public boolean assertSubtreeScope(ScopeNode node, Long id) throws NamingException {
        String dn = this.db.getEntryDn(id);
        DerefAliasesEnum mode = node.getDerefAliases();
        Long baseId = this.db.getEntryId(node.getBaseDn());
        boolean isDescendant = dn.endsWith(node.getBaseDn());
        if (!mode.isDerefInSearching()) {
            return isDescendant;
        }
        Index idx = this.db.getAliasIndex();
        if (null != idx.reverseLookup((Object)id)) {
            return false;
        }
        if (isDescendant) {
            return true;
        }
        idx = this.db.getSubAliasIndex();
        return idx.hasValue((Object)baseId, (Object)id);
    }

    public boolean assertOneLevelScope(ScopeNode node, Long id) throws NamingException {
        DerefAliasesEnum mode = node.getDerefAliases();
        Long baseId = this.db.getEntryId(node.getBaseDn());
        Index idx = this.db.getHierarchyIndex();
        boolean isChild = idx.hasValue((Object)baseId, (Object)id);
        if (!mode.isDerefInSearching()) {
            return isChild;
        }
        idx = this.db.getAliasIndex();
        if (null != idx.reverseLookup((Object)id)) {
            return false;
        }
        if (isChild) {
            return true;
        }
        idx = this.db.getOneAliasIndex();
        return idx.hasValue((Object)baseId, (Object)id);
    }
}

