/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.opencmis.bindings;

import java.io.IOException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisBaseException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisConstraintException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisContentAlreadyExistsException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisFilterNotValidException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisNameConstraintViolationException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisNotSupportedException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisPermissionDeniedException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisStorageException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisStreamNotSupportedException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisUpdateConflictException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisVersioningException;
import org.apache.commons.lang.math.NumberUtils;
import org.nuxeo.ecm.core.api.RecoverableClientException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NuxeoCmisErrorHelper {
    private static final Logger LOG = LoggerFactory.getLogger(NuxeoCmisErrorHelper.class);

    public static ErrorInfo extractError(Exception ex) {
        int statusCode = 500;
        String exceptionName = "runtime";
        if (ex instanceof CmisRuntimeException) {
            Throwable cause = ex.getCause();
            if (cause instanceof RecoverableClientException) {
                statusCode = NuxeoCmisErrorHelper.getHttpStatus((RecoverableClientException)cause);
            } else {
                LOG.error(ex.getMessage(), (Throwable)ex);
            }
        } else if (ex instanceof CmisStorageException) {
            LOG.error(ex.getMessage(), (Throwable)ex);
            statusCode = NuxeoCmisErrorHelper.getErrorCode((CmisBaseException)((CmisStorageException)ex));
            exceptionName = ((CmisStorageException)ex).getExceptionName();
        } else if (ex instanceof CmisBaseException) {
            statusCode = NuxeoCmisErrorHelper.getErrorCode((CmisBaseException)ex);
            exceptionName = ((CmisBaseException)ex).getExceptionName();
        } else if (ex instanceof IOException) {
            LOG.warn(ex.getMessage(), (Throwable)ex);
        } else {
            LOG.error(ex.getMessage(), (Throwable)ex);
        }
        String message = ex.getMessage();
        if (!(ex instanceof CmisBaseException)) {
            message = "An error occurred!";
        }
        return new ErrorInfo(statusCode, exceptionName, message);
    }

    public static int getHttpStatus(RecoverableClientException ex) {
        String lastParam;
        String[] params = ex.geLocalizedMessageParams();
        int len = params.length;
        if (len > 0 && NumberUtils.isDigits((String)(lastParam = params[len - 1]))) {
            try {
                return Integer.parseInt(lastParam);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return 500;
    }

    public static int getErrorCode(CmisBaseException ex) {
        if (ex instanceof CmisConstraintException) {
            return 409;
        }
        if (ex instanceof CmisContentAlreadyExistsException) {
            return 409;
        }
        if (ex instanceof CmisFilterNotValidException) {
            return 400;
        }
        if (ex instanceof CmisInvalidArgumentException) {
            return 400;
        }
        if (ex instanceof CmisNameConstraintViolationException) {
            return 409;
        }
        if (ex instanceof CmisNotSupportedException) {
            return 405;
        }
        if (ex instanceof CmisObjectNotFoundException) {
            return 404;
        }
        if (ex instanceof CmisPermissionDeniedException) {
            return 403;
        }
        if (ex instanceof CmisStorageException) {
            return 500;
        }
        if (ex instanceof CmisStreamNotSupportedException) {
            return 403;
        }
        if (ex instanceof CmisUpdateConflictException) {
            return 409;
        }
        if (ex instanceof CmisVersioningException) {
            return 409;
        }
        return 500;
    }

    public static class ErrorInfo {
        public int statusCode;
        public String exceptionName;
        public String message;

        public ErrorInfo(int statusCode, String exceptionName, String message) {
            this.statusCode = statusCode;
            this.exceptionName = exceptionName;
            this.message = message;
        }
    }
}

