/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.comm.internal;

import com.sun.jdmk.comm.AuthInfo;
import com.sun.jdmk.comm.CommunicationException;
import com.sun.jdmk.comm.CommunicatorServer;
import com.sun.jdmk.comm.HttpConnectorServer;
import com.sun.jdmk.comm.HttpsConnectorServer;
import com.sun.jdmk.comm.JdmkLegacyConnector;
import com.sun.jdmk.comm.RmiConnectorServer;
import com.sun.jdmk.comm.internal.EnvHelp;
import com.sun.jdmk.internal.ClassLogger;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Collections;
import java.util.Map;
import javax.management.AttributeChangeNotification;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXServiceURL;

public class JDMKServerConnector
extends JMXConnectorServer
implements JdmkLegacyConnector {
    private CommunicatorServer wrapped;
    private JMXServiceURL address;
    private Map env;
    private ClassLogger logger;

    public JDMKServerConnector(JMXServiceURL serviceURL, Map env, MBeanServer server) throws IOException {
        super(server);
        if (serviceURL == null) {
            throw new IllegalArgumentException("Null url.");
        }
        this.address = serviceURL;
        this.logger = new ClassLogger("com.sun.jdmk.comm.legacy.connector.wrapper", "JDMKClientConnector-" + this.address.getProtocol());
        if (this.logger.finerOn()) {
            this.logger.fine("Constructor", "Construct a JDMK legacy connector server wrapper: " + this.address);
        }
        this.env = env == null ? Collections.EMPTY_MAP : Collections.unmodifiableMap(env);
        String protocol = this.address.getProtocol();
        if ("jdmk-http".equals(protocol) || "jdmk-https".equals(protocol)) {
            this.wrapped = this.getHttpConnectorServer(this.address);
        } else if ("jdmk-rmi".equals(protocol)) {
            String sn = this.address.getURLPath();
            int i = sn.indexOf("/");
            if (i < 0 || sn.length() == i + 1) {
                sn = "name=RmiConnectorServer";
            } else if ((sn = sn.substring(i + 1)).trim().equals("")) {
                sn = "name=RmiConnectorServer";
            }
            this.wrapped = new RmiConnectorServer(serviceURL.getPort(), sn);
        } else {
            throw new IllegalArgumentException("Unknown protocol: " + protocol);
        }
    }

    private CommunicatorServer getHttpConnectorServer(JMXServiceURL address) throws IOException {
        if ("jdmk-http".equals(address.getProtocol())) {
            return new HttpConnectorServer(address.getPort(), this.getAuthInfo(), this.getLocalAddress());
        }
        return new HttpsConnectorServer(address.getPort(), this.getAuthInfo(), this.getLocalAddress(), this.getNeedClientAuth());
    }

    private AuthInfo[] getAuthInfo() throws IOException {
        try {
            return (AuthInfo[])this.env.get("com.sun.jdmk.http.server.authinfo.list");
        }
        catch (ClassCastException e) {
            IOException ioe = new IOException(e.toString());
            EnvHelp.initCause(ioe, e);
            throw ioe;
        }
    }

    private InetAddress getLocalAddress() throws IOException {
        try {
            return (InetAddress)this.env.get("com.sun.jdmk.http.server.local.address");
        }
        catch (ClassCastException e) {
            IOException ioe = new IOException(e.toString());
            EnvHelp.initCause(ioe, e);
            throw ioe;
        }
    }

    private boolean getNeedClientAuth() throws IOException {
        try {
            String needClientAuth = (String)this.env.get("com.sun.jdmk.https.server.need.client.auth");
            return needClientAuth == null || !"false".equals(needClientAuth.toLowerCase());
        }
        catch (ClassCastException e) {
            IOException ioe = new IOException(e.toString());
            EnvHelp.initCause(ioe, e);
            throw ioe;
        }
    }

    @Override
    public JMXServiceURL getAddress() {
        return this.address;
    }

    public Map getAttributes() {
        Map map = EnvHelp.filterAttributes(this.env);
        return Collections.unmodifiableMap(map);
    }

    @Override
    public boolean isActive() {
        return this.wrapped.isActive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws IOException {
        if (this.logger.finerOn()) {
            this.logger.fine("start", "start the server: " + this.address);
        }
        int[] hb = new int[]{};
        MyListener ml = new MyListener(hb);
        this.wrapped.addNotificationListener(ml, null, hb);
        try {
            this.wrapped.start();
        }
        catch (CommunicationException ce) {
            IOException ioe = new IOException(ce.toString());
            if (ce.getTargetException() != null) {
                EnvHelp.initCause(ioe, ce.getTargetException());
            } else {
                EnvHelp.initCause(ioe, ce);
            }
            throw ioe;
        }
        int[] nArray = hb;
        synchronized (hb) {
            while (!ml.stateChanged) {
                try {
                    hb.wait();
                }
                catch (InterruptedException ie) {
                    break;
                }
            }
            // ** MonitorExit[var3_4] (shouldn't be in output)
            try {
                this.wrapped.removeNotificationListener(ml);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!this.wrapped.isActive()) {
                throw new IOException("Failed to start the server, the server is not active.");
            }
            return;
        }
    }

    @Override
    public void stop() throws IOException {
        if (this.logger.finerOn()) {
            this.logger.fine("stop", "stop the server: " + this.address);
        }
        this.wrapped.stop();
    }

    @Override
    public String[] getConnectionIds() {
        throw new UnsupportedOperationException("Sorry.");
    }

    @Override
    public Object getWrapped() {
        return this.wrapped;
    }

    @Override
    public ObjectName preRegister(MBeanServer server, ObjectName name) {
        super.preRegister(server, name);
        try {
            return this.wrapped.preRegister(server, name);
        }
        catch (Exception exception) {
            return name;
        }
    }

    @Override
    public void postRegister(Boolean registrationDone) {
        this.wrapped.postRegister(registrationDone);
    }

    @Override
    public void preDeregister() throws Exception {
        this.wrapped.preDeregister();
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        return new MBeanNotificationInfo[0];
    }

    private class MyListener
    implements NotificationListener {
        public boolean stateChanged = false;
        private Object handback;

        public MyListener(Object handback) {
            this.handback = handback;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleNotification(Notification n, Object hb) {
            if (this.handback != hb || !(n instanceof AttributeChangeNotification) || JDMKServerConnector.this.wrapped.getState() == 3) {
                return;
            }
            Object object = this.handback;
            synchronized (object) {
                this.stateChanged = true;
                this.handback.notifyAll();
            }
        }
    }
}

