/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.contentview.seam;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.SortInfo;
import org.nuxeo.ecm.platform.contentview.jsf.ContentView;
import org.nuxeo.ecm.platform.contentview.jsf.ContentViewService;
import org.nuxeo.ecm.platform.contentview.jsf.ContentViewState;
import org.nuxeo.ecm.platform.contentview.jsf.ContentViewStateImpl;
import org.nuxeo.ecm.platform.contentview.json.JSONContentViewState;

@Name(value="contentViewRestActions")
@Scope(value=ScopeType.EVENT)
public class ContentViewRestActions
implements Serializable {
    private static final long serialVersionUID = 1L;
    @In(create=true)
    protected ContentViewService contentViewService;

    public String getContentViewState(ContentView contentView) throws UnsupportedEncodingException, ClientException {
        ContentViewState state = this.contentViewService.saveContentView(contentView);
        if (state != null) {
            return JSONContentViewState.toJSON(state, true);
        }
        return null;
    }

    public ContentView restoreContentView(String contentViewName, Long currentPage, Long pageSize, List<SortInfo> sortInfos, String jsonContentViewState) throws UnsupportedEncodingException, ClientException {
        ContentViewState state = null;
        if (jsonContentViewState != null && jsonContentViewState.trim().length() != 0) {
            state = JSONContentViewState.fromJSON(jsonContentViewState, true);
        } else if (contentViewName != null) {
            state = new ContentViewStateImpl();
            state.setContentViewName(contentViewName);
        }
        if (state != null) {
            if (currentPage != null && currentPage != -1L) {
                state.setCurrentPage(currentPage);
            }
            if (pageSize != null && pageSize != -1L) {
                state.setPageSize(pageSize);
            }
            if (sortInfos != null) {
                state.setSortInfos(sortInfos);
            }
        }
        return this.contentViewService.restoreContentView(state);
    }

    public List<SortInfo> getSortInfos(String sortColumn, boolean ascending) {
        ArrayList<SortInfo> sortInfos = new ArrayList<SortInfo>();
        sortInfos.add(new SortInfo(sortColumn, ascending));
        return sortInfos;
    }
}

