/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.forms.layout.core.registries;

import java.util.ArrayList;
import java.util.List;
import org.nuxeo.ecm.platform.forms.layout.api.LayoutTypeDefinition;
import org.nuxeo.runtime.model.ContributionFragmentRegistry;
import org.nuxeo.runtime.model.SimpleContributionRegistry;

public class LayoutTypeDefinitionRegistry
extends SimpleContributionRegistry<LayoutTypeDefinition> {
    protected final String category;

    public LayoutTypeDefinitionRegistry(String category) {
        this.category = category;
    }

    public String getCategory() {
        return this.category;
    }

    public String getContributionId(LayoutTypeDefinition contrib) {
        return contrib.getName();
    }

    public List<LayoutTypeDefinition> getDefinitions() {
        ArrayList<LayoutTypeDefinition> res = new ArrayList<LayoutTypeDefinition>();
        for (LayoutTypeDefinition item : this.currentContribs.values()) {
            if (item == null) continue;
            res.add(item);
        }
        return res;
    }

    public LayoutTypeDefinition getDefinition(String id) {
        return (LayoutTypeDefinition)this.getCurrentContribution(id);
    }

    public synchronized void addContribution(LayoutTypeDefinition contrib) {
        super.addContribution((Object)contrib);
        List aliases = contrib.getAliases();
        if (aliases != null) {
            for (String alias : aliases) {
                ContributionFragmentRegistry.FragmentList head = this.addFragment(alias, contrib);
                this.contributionUpdated(alias, head.merge((ContributionFragmentRegistry)this), contrib);
            }
        }
    }

    public synchronized void removeContribution(LayoutTypeDefinition contrib, boolean useEqualsMethod) {
        super.removeContribution((Object)contrib, useEqualsMethod);
        List aliases = contrib.getAliases();
        if (aliases != null) {
            for (String alias : aliases) {
                ContributionFragmentRegistry.FragmentList head = this.removeFragment(alias, contrib, useEqualsMethod);
                if (head == null) continue;
                LayoutTypeDefinition result = (LayoutTypeDefinition)head.merge((ContributionFragmentRegistry)this);
                if (result != null) {
                    this.contributionUpdated(alias, result, contrib);
                    continue;
                }
                this.contributionRemoved(alias, contrib);
            }
        }
    }
}

