/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.suggestbox.automation;

import java.util.List;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.impl.blob.StringBlob;
import org.nuxeo.ecm.platform.suggestbox.service.Suggestion;
import org.nuxeo.ecm.platform.suggestbox.service.SuggestionContext;
import org.nuxeo.ecm.platform.suggestbox.service.SuggestionService;

@Operation(id="Search.SuggestersLauncher", category="User Interface", label="Suggesters launcher", description="Get and launch the suggesters defined and return a list of Suggestion objects.", addToStudio=false)
public class SuggestOperation {
    public static final String ID = "Search.SuggestersLauncher";
    private static final String SUGGESTER_GROUP = "searchbox";
    @Context
    protected CoreSession session;
    @Context
    protected SuggestionService serviceSuggestion;
    @Param(name="searchTerm", required=false)
    protected String searchTerm;

    @OperationMethod
    public Blob run() throws Exception {
        JSONArray result = new JSONArray();
        SuggestionContext suggestionContext = new SuggestionContext(SUGGESTER_GROUP, this.session.getPrincipal());
        suggestionContext.withSession(this.session);
        List<Suggestion> listSuggestions = this.serviceSuggestion.suggest(this.searchTerm, suggestionContext);
        for (Suggestion suggestion : listSuggestions) {
            JSONObject suggestionJSON = new JSONObject();
            suggestionJSON.put((Object)"id", (Object)suggestion.getId());
            suggestionJSON.put((Object)"label", (Object)suggestion.getLabel());
            suggestionJSON.put((Object)"type", (Object)suggestion.getType());
            suggestionJSON.put((Object)"icon", (Object)suggestion.getIconURL());
            suggestionJSON.put((Object)"url", (Object)suggestion.getObjectUrl());
            result.add((Object)suggestionJSON);
        }
        return new StringBlob(result.toString(), "application/json");
    }
}

