/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives.decorators;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.collections.primitives.FloatIterator;
import org.apache.commons.collections.primitives.decorators.ProxyFloatIterator;

public final class UnmodifiableFloatIterator
extends ProxyFloatIterator {
    private FloatIterator m_aProxied;

    UnmodifiableFloatIterator(@Nonnull FloatIterator floatIterator) {
        this.m_aProxied = floatIterator;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("This FloatIterator is not modifiable.");
    }

    @Override
    @Nonnull
    protected FloatIterator getIterator() {
        return this.m_aProxied;
    }

    @Nullable
    public static final FloatIterator wrap(@Nullable FloatIterator floatIterator) {
        if (null == floatIterator) {
            return null;
        }
        if (floatIterator instanceof UnmodifiableFloatIterator) {
            return floatIterator;
        }
        return new UnmodifiableFloatIterator(floatIterator);
    }
}

