/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives.adapters;

import com.phloc.commons.annotations.ReturnsMutableCopy;
import java.util.Collection;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import org.apache.commons.collections.primitives.CharCollection;
import org.apache.commons.collections.primitives.CharIterator;
import org.apache.commons.collections.primitives.adapters.CharCollectionCollection;
import org.apache.commons.collections.primitives.adapters.IteratorCharIterator;

abstract class AbstractCollectionCharCollection
implements CharCollection {
    protected AbstractCollectionCharCollection() {
    }

    @Nonnull
    protected abstract Collection<Character> getCollection();

    @Override
    public boolean add(char c) {
        return this.getCollection().add(Character.valueOf(c));
    }

    @Override
    public boolean addAll(@Nonnull CharCollection charCollection) {
        return this.getCollection().addAll(CharCollectionCollection.wrap(charCollection));
    }

    @Override
    public void clear() {
        this.getCollection().clear();
    }

    @Override
    public boolean contains(char c) {
        return this.getCollection().contains(Character.valueOf(c));
    }

    @Override
    public boolean containsAll(@Nonnull CharCollection charCollection) {
        return this.getCollection().containsAll(CharCollectionCollection.wrap(charCollection));
    }

    @Override
    public boolean isEmpty() {
        return this.getCollection().isEmpty();
    }

    @Override
    @Nonnull
    public CharIterator iterator() {
        return IteratorCharIterator.wrap(this.getCollection().iterator());
    }

    @Override
    public boolean removeElement(char c) {
        return this.getCollection().remove(Character.valueOf(c));
    }

    @Override
    public boolean removeAll(@Nonnull CharCollection charCollection) {
        return this.getCollection().removeAll(CharCollectionCollection.wrap(charCollection));
    }

    @Override
    public boolean retainAll(@Nonnull CharCollection charCollection) {
        return this.getCollection().retainAll(CharCollectionCollection.wrap(charCollection));
    }

    @Override
    @Nonnegative
    public int size() {
        return this.getCollection().size();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public char[] toArray() {
        Object[] objectArray = this.getCollection().toArray();
        char[] cArray = new char[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            cArray[i] = ((Character)objectArray[i]).charValue();
        }
        return cArray;
    }

    @Override
    @Nonnull
    public char[] toArray(@Nonnull char[] cArray) {
        char[] cArray2 = cArray;
        Object[] objectArray = this.getCollection().toArray();
        if (cArray2.length < objectArray.length) {
            cArray2 = new char[objectArray.length];
        }
        for (int i = 0; i < objectArray.length; ++i) {
            cArray2[i] = ((Character)objectArray[i]).charValue();
        }
        return cArray2;
    }

    public String toString() {
        return this.getCollection().toString();
    }
}

