/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives.adapters;

import com.phloc.commons.annotations.ReturnsMutableCopy;
import java.util.Collection;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import org.apache.commons.collections.primitives.BooleanCollection;
import org.apache.commons.collections.primitives.BooleanIterator;
import org.apache.commons.collections.primitives.adapters.BooleanCollectionCollection;
import org.apache.commons.collections.primitives.adapters.IteratorBooleanIterator;

abstract class AbstractCollectionBooleanCollection
implements BooleanCollection {
    protected AbstractCollectionBooleanCollection() {
    }

    @Nonnull
    protected abstract Collection<Boolean> getCollection();

    @Override
    public boolean add(boolean bl) {
        return this.getCollection().add(bl);
    }

    @Override
    public boolean addAll(@Nonnull BooleanCollection booleanCollection) {
        return this.getCollection().addAll(BooleanCollectionCollection.wrap(booleanCollection));
    }

    @Override
    public void clear() {
        this.getCollection().clear();
    }

    @Override
    public boolean contains(boolean bl) {
        return this.getCollection().contains(bl);
    }

    @Override
    public boolean containsAll(@Nonnull BooleanCollection booleanCollection) {
        return this.getCollection().containsAll(BooleanCollectionCollection.wrap(booleanCollection));
    }

    @Override
    public boolean isEmpty() {
        return this.getCollection().isEmpty();
    }

    @Override
    @Nonnull
    public BooleanIterator iterator() {
        return IteratorBooleanIterator.wrap(this.getCollection().iterator());
    }

    @Override
    public boolean removeElement(boolean bl) {
        return this.getCollection().remove(bl);
    }

    @Override
    public boolean removeAll(@Nonnull BooleanCollection booleanCollection) {
        return this.getCollection().removeAll(BooleanCollectionCollection.wrap(booleanCollection));
    }

    @Override
    public boolean retainAll(@Nonnull BooleanCollection booleanCollection) {
        return this.getCollection().retainAll(BooleanCollectionCollection.wrap(booleanCollection));
    }

    @Override
    @Nonnegative
    public int size() {
        return this.getCollection().size();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public boolean[] toArray() {
        Object[] objectArray = this.getCollection().toArray();
        boolean[] blArray = new boolean[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            blArray[i] = (Boolean)objectArray[i];
        }
        return blArray;
    }

    @Override
    @Nonnull
    public boolean[] toArray(@Nonnull boolean[] blArray) {
        boolean[] blArray2 = blArray;
        Object[] objectArray = this.getCollection().toArray();
        if (blArray2.length < objectArray.length) {
            blArray2 = new boolean[objectArray.length];
        }
        for (int i = 0; i < objectArray.length; ++i) {
            blArray2[i] = (Boolean)objectArray[i];
        }
        return blArray2;
    }

    public String toString() {
        return this.getCollection().toString();
    }
}

