/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives;

import java.util.EmptyStackException;
import javax.annotation.Nonnegative;
import org.apache.commons.collections.primitives.ArrayShortList;

public class ShortStack {
    private final ArrayShortList m_aList = new ArrayShortList();

    public ShortStack() {
    }

    public ShortStack(short[] sArray) {
        for (short s : sArray) {
            this.m_aList.add(s);
        }
    }

    @Deprecated
    public boolean empty() {
        return this.isEmpty();
    }

    public boolean isEmpty() {
        return this.m_aList.isEmpty();
    }

    public short peek() {
        if (this.m_aList.isEmpty()) {
            throw new EmptyStackException();
        }
        return this.m_aList.get(this.m_aList.size() - 1);
    }

    public short peek(int n) {
        if (this.m_aList.isEmpty()) {
            throw new EmptyStackException();
        }
        return this.m_aList.get(this.m_aList.size() - n - 1);
    }

    public short pop() {
        if (this.m_aList.isEmpty()) {
            throw new EmptyStackException();
        }
        return this.m_aList.removeElementAt(this.m_aList.size() - 1);
    }

    public short push(short s) {
        this.m_aList.add(s);
        return s;
    }

    public int search(short s) {
        for (int i = this.m_aList.size() - 1; i >= 0; --i) {
            if (this.m_aList.get(i) != s) continue;
            return this.m_aList.size() - i;
        }
        return -1;
    }

    public short get(int n) {
        return this.m_aList.get(n);
    }

    @Nonnegative
    public int size() {
        return this.m_aList.size();
    }

    public void clear() {
        this.m_aList.clear();
    }
}

