/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives;

import com.phloc.commons.hash.HashCodeGenerator;
import java.util.ConcurrentModificationException;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.collections.primitives.AbstractLongCollection;
import org.apache.commons.collections.primitives.LongCollection;
import org.apache.commons.collections.primitives.LongIterator;
import org.apache.commons.collections.primitives.LongList;
import org.apache.commons.collections.primitives.LongListIterator;

public abstract class RandomAccessLongList
extends AbstractLongCollection
implements LongList {
    private int _modCount = 0;

    protected RandomAccessLongList() {
    }

    @Override
    public abstract long get(int var1);

    @Override
    public abstract int size();

    @Override
    public long removeElementAt(int n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long set(int n, long l) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(int n, long l) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(long l) {
        this.add(this.size(), l);
        return true;
    }

    @Override
    public boolean addAll(int n, @Nonnull LongCollection longCollection) {
        int n2 = n;
        boolean bl = false;
        LongIterator longIterator = longCollection.iterator();
        while (longIterator.hasNext()) {
            this.add(n2++, longIterator.next());
            bl = true;
        }
        return bl;
    }

    @Override
    public int indexOf(long l) {
        int n = 0;
        LongIterator longIterator = this.iterator();
        while (longIterator.hasNext()) {
            if (longIterator.next() == l) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(long l) {
        LongListIterator longListIterator = this.listIterator(this.size());
        while (longListIterator.hasPrevious()) {
            if (longListIterator.previous() != l) continue;
            return longListIterator.nextIndex();
        }
        return -1;
    }

    @Override
    public LongIterator iterator() {
        return this.listIterator();
    }

    @Override
    public LongListIterator listIterator() {
        return this.listIterator(0);
    }

    @Override
    public LongListIterator listIterator(int n) {
        return new RandomAccessLongListIterator(this, n);
    }

    @Override
    public LongList subList(int n, int n2) {
        return new RandomAccessLongSubList(this, n, n2);
    }

    @Override
    public boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof LongList)) {
            return false;
        }
        LongList longList = (LongList)object;
        if (this.size() != longList.size()) {
            return false;
        }
        LongIterator longIterator = longList.iterator();
        LongIterator longIterator2 = this.iterator();
        while (longIterator2.hasNext()) {
            if (longIterator2.next() == longIterator.next()) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        HashCodeGenerator hashCodeGenerator = new HashCodeGenerator(this);
        LongIterator longIterator = this.iterator();
        while (longIterator.hasNext()) {
            hashCodeGenerator.append(longIterator.next());
        }
        return hashCodeGenerator.getHashCode();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        LongIterator longIterator = this.iterator();
        while (longIterator.hasNext()) {
            stringBuilder.append(longIterator.next());
            if (!longIterator.hasNext()) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    protected int getModCount() {
        return this._modCount;
    }

    protected void incrModCount() {
        ++this._modCount;
    }

    protected static class RandomAccessLongSubList
    extends RandomAccessLongList {
        private int _offset = 0;
        private int _limit = 0;
        private RandomAccessLongList _list = null;
        private ComodChecker _comod = null;

        RandomAccessLongSubList(RandomAccessLongList randomAccessLongList, int n, int n2) {
            if (n < 0 || n2 > randomAccessLongList.size()) {
                throw new IndexOutOfBoundsException();
            }
            if (n > n2) {
                throw new IllegalArgumentException();
            }
            this._list = randomAccessLongList;
            this._offset = n;
            this._limit = n2 - n;
            this._comod = new ComodChecker(randomAccessLongList);
            this._comod.resyncModCount();
        }

        @Override
        public long get(int n) {
            this.checkRange(n);
            this._comod.assertNotComodified();
            return this._list.get(this.toUnderlyingIndex(n));
        }

        @Override
        public long removeElementAt(int n) {
            this.checkRange(n);
            this._comod.assertNotComodified();
            long l = this._list.removeElementAt(this.toUnderlyingIndex(n));
            --this._limit;
            this._comod.resyncModCount();
            this.incrModCount();
            return l;
        }

        @Override
        public long set(int n, long l) {
            this.checkRange(n);
            this._comod.assertNotComodified();
            long l2 = this._list.set(this.toUnderlyingIndex(n), l);
            this.incrModCount();
            this._comod.resyncModCount();
            return l2;
        }

        @Override
        public void add(int n, long l) {
            this.checkRangeIncludingEndpoint(n);
            this._comod.assertNotComodified();
            this._list.add(this.toUnderlyingIndex(n), l);
            ++this._limit;
            this._comod.resyncModCount();
            this.incrModCount();
        }

        @Override
        public int size() {
            this._comod.assertNotComodified();
            return this._limit;
        }

        private void checkRange(int n) {
            if (n < 0 || n >= this.size()) {
                throw new IndexOutOfBoundsException("index " + n + " not in [0," + this.size() + ")");
            }
        }

        private void checkRangeIncludingEndpoint(int n) {
            if (n < 0 || n > this.size()) {
                throw new IndexOutOfBoundsException("index " + n + " not in [0," + this.size() + "]");
            }
        }

        private int toUnderlyingIndex(int n) {
            return n + this._offset;
        }
    }

    protected static class RandomAccessLongListIterator
    extends ComodChecker
    implements LongListIterator {
        private int _nextIndex = 0;
        private int _lastReturnedIndex = -1;

        RandomAccessLongListIterator(RandomAccessLongList randomAccessLongList, int n) {
            super(randomAccessLongList);
            if (n < 0 || n > this.getList().size()) {
                throw new IndexOutOfBoundsException("Index " + n + " not in [0," + this.getList().size() + ")");
            }
            this._nextIndex = n;
            this.resyncModCount();
        }

        @Override
        public boolean hasNext() {
            this.assertNotComodified();
            return this._nextIndex < this.getList().size();
        }

        @Override
        public boolean hasPrevious() {
            this.assertNotComodified();
            return this._nextIndex > 0;
        }

        @Override
        public int nextIndex() {
            this.assertNotComodified();
            return this._nextIndex;
        }

        @Override
        public int previousIndex() {
            this.assertNotComodified();
            return this._nextIndex - 1;
        }

        @Override
        public long next() {
            this.assertNotComodified();
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            long l = this.getList().get(this._nextIndex);
            this._lastReturnedIndex = this._nextIndex++;
            return l;
        }

        @Override
        public long previous() {
            this.assertNotComodified();
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            long l = this.getList().get(this._nextIndex - 1);
            this._lastReturnedIndex = this._nextIndex - 1;
            --this._nextIndex;
            return l;
        }

        @Override
        public void add(long l) {
            this.assertNotComodified();
            this.getList().add(this._nextIndex, l);
            ++this._nextIndex;
            this._lastReturnedIndex = -1;
            this.resyncModCount();
        }

        @Override
        public void remove() {
            this.assertNotComodified();
            if (this._lastReturnedIndex == -1) {
                throw new IllegalStateException();
            }
            if (this._lastReturnedIndex == this._nextIndex) {
                this.getList().removeElementAt(this._lastReturnedIndex);
            } else {
                this.getList().removeElementAt(this._lastReturnedIndex);
                --this._nextIndex;
            }
            this._lastReturnedIndex = -1;
            this.resyncModCount();
        }

        @Override
        public void set(long l) {
            this.assertNotComodified();
            if (-1 == this._lastReturnedIndex) {
                throw new IllegalStateException();
            }
            this.getList().set(this._lastReturnedIndex, l);
            this.resyncModCount();
        }
    }

    private static class ComodChecker {
        private RandomAccessLongList _source = null;
        private int _expectedModCount = -1;

        ComodChecker(RandomAccessLongList randomAccessLongList) {
            this._source = randomAccessLongList;
            this.resyncModCount();
        }

        protected RandomAccessLongList getList() {
            return this._source;
        }

        protected void assertNotComodified() throws ConcurrentModificationException {
            if (this._expectedModCount != this.getList().getModCount()) {
                throw new ConcurrentModificationException();
            }
        }

        protected void resyncModCount() {
            this._expectedModCount = this.getList().getModCount();
        }
    }
}

