/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives;

import javax.annotation.Nonnull;
import org.apache.commons.collections.primitives.ArrayFloatList;
import org.apache.commons.collections.primitives.FloatIterator;
import org.apache.commons.collections.primitives.FloatList;
import org.apache.commons.collections.primitives.FloatListIterator;
import org.apache.commons.collections.primitives.decorators.UnmodifiableFloatIterator;
import org.apache.commons.collections.primitives.decorators.UnmodifiableFloatList;
import org.apache.commons.collections.primitives.decorators.UnmodifiableFloatListIterator;

public final class FloatCollections {
    public static final FloatList EMPTY_FLOAT_LIST = FloatCollections.unmodifiableFloatList(new ArrayFloatList(0));
    public static final FloatIterator EMPTY_FLOAT_ITERATOR = FloatCollections.unmodifiableFloatIterator(EMPTY_FLOAT_LIST.iterator());
    public static final FloatListIterator EMPTY_FLOAT_LIST_ITERATOR = FloatCollections.unmodifiableFloatListIterator(EMPTY_FLOAT_LIST.listIterator());

    private FloatCollections() {
    }

    @Nonnull
    public static FloatList singletonFloatList(float f) {
        ArrayFloatList arrayFloatList = new ArrayFloatList(1);
        arrayFloatList.add(f);
        return UnmodifiableFloatList.wrap(arrayFloatList);
    }

    @Nonnull
    public static FloatIterator singletonFloatIterator(float f) {
        return FloatCollections.singletonFloatList(f).iterator();
    }

    @Nonnull
    public static FloatListIterator singletonFloatListIterator(float f) {
        return FloatCollections.singletonFloatList(f).listIterator();
    }

    @Nonnull
    public static FloatList unmodifiableFloatList(@Nonnull FloatList floatList) throws NullPointerException {
        if (null == floatList) {
            throw new NullPointerException();
        }
        return UnmodifiableFloatList.wrap(floatList);
    }

    @Nonnull
    public static FloatIterator unmodifiableFloatIterator(@Nonnull FloatIterator floatIterator) {
        if (null == floatIterator) {
            throw new NullPointerException();
        }
        return UnmodifiableFloatIterator.wrap(floatIterator);
    }

    @Nonnull
    public static FloatListIterator unmodifiableFloatListIterator(@Nonnull FloatListIterator floatListIterator) {
        if (null == floatListIterator) {
            throw new NullPointerException();
        }
        return UnmodifiableFloatListIterator.wrap(floatListIterator);
    }

    @Nonnull
    public static FloatList getEmptyFloatList() {
        return EMPTY_FLOAT_LIST;
    }

    @Nonnull
    public static FloatIterator getEmptyFloatIterator() {
        return EMPTY_FLOAT_ITERATOR;
    }

    @Nonnull
    public static FloatListIterator getEmptyFloatListIterator() {
        return EMPTY_FLOAT_LIST_ITERATOR;
    }
}

