/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives;

import java.util.EmptyStackException;
import javax.annotation.Nonnegative;
import org.apache.commons.collections.primitives.ArrayByteList;

public class ByteStack {
    private final ArrayByteList m_aList = new ArrayByteList();

    public ByteStack() {
    }

    public ByteStack(byte[] byArray) {
        for (byte by : byArray) {
            this.m_aList.add(by);
        }
    }

    @Deprecated
    public boolean empty() {
        return this.isEmpty();
    }

    public boolean isEmpty() {
        return this.m_aList.isEmpty();
    }

    public byte peek() {
        if (this.m_aList.isEmpty()) {
            throw new EmptyStackException();
        }
        return this.m_aList.get(this.m_aList.size() - 1);
    }

    public byte peek(int n) {
        if (this.m_aList.isEmpty()) {
            throw new EmptyStackException();
        }
        return this.m_aList.get(this.m_aList.size() - n - 1);
    }

    public byte pop() {
        if (this.m_aList.isEmpty()) {
            throw new EmptyStackException();
        }
        return this.m_aList.removeElementAt(this.m_aList.size() - 1);
    }

    public byte push(byte by) {
        this.m_aList.add(by);
        return by;
    }

    public int search(byte by) {
        for (int i = this.m_aList.size() - 1; i >= 0; --i) {
            if (this.m_aList.get(i) != by) continue;
            return this.m_aList.size() - i;
        }
        return -1;
    }

    public byte get(int n) {
        return this.m_aList.get(n);
    }

    @Nonnegative
    public int size() {
        return this.m_aList.size();
    }

    public void clear() {
        this.m_aList.clear();
    }
}

