/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.apache.commons.collections.primitives.IntCollection;
import org.apache.commons.collections.primitives.RandomAccessIntList;

@SuppressFBWarnings(value={"SE_NO_SERIALVERSIONID"})
public class ArrayUnsignedShortList
extends RandomAccessIntList
implements Serializable {
    public static final int MAX_VALUE = 65535;
    public static final int MIN_VALUE = 0;
    private transient short[] _data;
    private int _size;

    public ArrayUnsignedShortList() {
        this(8);
    }

    public ArrayUnsignedShortList(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("capacity " + n);
        }
        this._data = new short[n];
        this._size = 0;
    }

    public ArrayUnsignedShortList(IntCollection intCollection) {
        this(intCollection.size());
        this.addAll(intCollection);
    }

    public ArrayUnsignedShortList(int[] nArray) {
        this(nArray.length);
        for (int i = 0; i < nArray.length; ++i) {
            this._data[i] = this._fromInt(nArray[i]);
        }
        this._size = nArray.length;
    }

    @Override
    public int get(int n) {
        this._checkRange(n);
        return this._toInt(this._data[n]);
    }

    @Override
    public int size() {
        return this._size;
    }

    @Override
    public int removeElementAt(int n) {
        this._checkRange(n);
        this.incrModCount();
        int n2 = this._toInt(this._data[n]);
        int n3 = this._size - n - 1;
        if (n3 > 0) {
            System.arraycopy(this._data, n + 1, this._data, n, n3);
        }
        --this._size;
        return n2;
    }

    @Override
    public int set(int n, int n2) {
        this._assertValidUnsignedShort(n2);
        this._checkRange(n);
        this.incrModCount();
        int n3 = this._toInt(this._data[n]);
        this._data[n] = this._fromInt(n2);
        return n3;
    }

    @Override
    public void add(int n, int n2) {
        this._assertValidUnsignedShort(n2);
        this._checkRangeIncludingEndpoint(n);
        this.incrModCount();
        this.ensureCapacity(this._size + 1);
        int n3 = this._size - n;
        System.arraycopy(this._data, n, this._data, n + 1, n3);
        this._data[n] = this._fromInt(n2);
        ++this._size;
    }

    @Override
    public void clear() {
        this.incrModCount();
        this._size = 0;
    }

    public void ensureCapacity(int n) {
        this.incrModCount();
        if (n > this._data.length) {
            int n2 = this._data.length * 3 / 2 + 1;
            short[] sArray = this._data;
            this._data = new short[n2 < n ? n : n2];
            System.arraycopy(sArray, 0, this._data, 0, this._size);
        }
    }

    public void trimToSize() {
        this.incrModCount();
        if (this._size < this._data.length) {
            short[] sArray = this._data;
            this._data = new short[this._size];
            System.arraycopy(sArray, 0, this._data, 0, this._size);
        }
    }

    private final int _toInt(short s) {
        return s & 0xFFFF;
    }

    private final short _fromInt(int n) {
        return (short)(n & 0xFFFF);
    }

    private final void _assertValidUnsignedShort(int n) throws IllegalArgumentException {
        if (n > 65535) {
            throw new IllegalArgumentException(n + " > " + 65535);
        }
        if (n < 0) {
            throw new IllegalArgumentException(n + " < " + 0);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this._data.length);
        for (int i = 0; i < this._size; ++i) {
            objectOutputStream.writeShort(this._data[i]);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this._data = new short[objectInputStream.readInt()];
        for (int i = 0; i < this._size; ++i) {
            this._data[i] = objectInputStream.readShort();
        }
    }

    private final void _checkRange(int n) {
        if (n < 0 || n >= this._size) {
            throw new IndexOutOfBoundsException("Should be at least 0 and less than " + this._size + ", found " + n);
        }
    }

    private final void _checkRangeIncludingEndpoint(int n) {
        if (n < 0 || n > this._size) {
            throw new IndexOutOfBoundsException("Should be at least 0 and at most " + this._size + ", found " + n);
        }
    }
}

