/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.annotation.Nonnull;
import org.apache.commons.collections.primitives.ByteCollection;
import org.apache.commons.collections.primitives.ByteIterator;
import org.apache.commons.collections.primitives.RandomAccessByteList;

@SuppressFBWarnings(value={"SE_NO_SERIALVERSIONID"})
public class ArrayByteList
extends RandomAccessByteList
implements Serializable {
    private transient byte[] _data;
    private int _size;

    public ArrayByteList() {
        this(8);
    }

    public ArrayByteList(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("capacity " + n);
        }
        this._data = new byte[n];
        this._size = 0;
    }

    public ArrayByteList(@Nonnull ByteCollection byteCollection) {
        this(byteCollection.size());
        this.addAll(byteCollection);
    }

    public ArrayByteList(@Nonnull byte[] byArray) {
        this(byArray.length);
        System.arraycopy(byArray, 0, this._data, 0, byArray.length);
        this._size = byArray.length;
    }

    @Override
    public byte get(int n) {
        this._checkRange(n);
        return this._data[n];
    }

    @Override
    public int size() {
        return this._size;
    }

    @Override
    public byte removeElementAt(int n) {
        this._checkRange(n);
        this.incrModCount();
        byte by = this._data[n];
        int n2 = this._size - n - 1;
        if (n2 > 0) {
            System.arraycopy(this._data, n + 1, this._data, n, n2);
        }
        --this._size;
        return by;
    }

    @Override
    public byte set(int n, byte by) {
        this._checkRange(n);
        this.incrModCount();
        byte by2 = this._data[n];
        this._data[n] = by;
        return by2;
    }

    @Override
    public void add(int n, byte by) {
        this._checkRangeIncludingEndpoint(n);
        this.incrModCount();
        this.ensureCapacity(this._size + 1);
        int n2 = this._size - n;
        System.arraycopy(this._data, n, this._data, n + 1, n2);
        this._data[n] = by;
        ++this._size;
    }

    @Override
    public void clear() {
        this.incrModCount();
        this._size = 0;
    }

    @Override
    public boolean addAll(@Nonnull ByteCollection byteCollection) {
        return this.addAll(this.size(), byteCollection);
    }

    @Override
    public boolean addAll(int n, @Nonnull ByteCollection byteCollection) {
        if (byteCollection.size() == 0) {
            return false;
        }
        int n2 = n;
        this._checkRangeIncludingEndpoint(n2);
        this.incrModCount();
        this.ensureCapacity(this._size + byteCollection.size());
        if (n2 != this._size) {
            System.arraycopy(this._data, n2, this._data, n2 + byteCollection.size(), this._size - n2);
        }
        ByteIterator byteIterator = byteCollection.iterator();
        while (byteIterator.hasNext()) {
            this._data[n2] = byteIterator.next();
            ++n2;
        }
        this._size += byteCollection.size();
        return true;
    }

    public void ensureCapacity(int n) {
        this.incrModCount();
        if (n > this._data.length) {
            int n2 = this._data.length * 3 / 2 + 1;
            byte[] byArray = this._data;
            this._data = new byte[n2 < n ? n : n2];
            System.arraycopy(byArray, 0, this._data, 0, this._size);
        }
    }

    public void trimToSize() {
        this.incrModCount();
        if (this._size < this._data.length) {
            byte[] byArray = this._data;
            this._data = new byte[this._size];
            System.arraycopy(byArray, 0, this._data, 0, this._size);
        }
    }

    private void writeObject(@Nonnull ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this._data.length);
        for (int i = 0; i < this._size; ++i) {
            objectOutputStream.writeByte(this._data[i]);
        }
    }

    private void readObject(@Nonnull ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this._data = new byte[objectInputStream.readInt()];
        for (int i = 0; i < this._size; ++i) {
            this._data[i] = objectInputStream.readByte();
        }
    }

    private final void _checkRange(int n) {
        if (n < 0 || n >= this._size) {
            throw new IndexOutOfBoundsException("Should be at least 0 and less than " + this._size + ", found " + n);
        }
    }

    private final void _checkRangeIncludingEndpoint(int n) {
        if (n < 0 || n > this._size) {
            throw new IndexOutOfBoundsException("Should be at least 0 and at most " + this._size + ", found " + n);
        }
    }
}

