/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives;

import com.phloc.commons.annotations.ReturnsMutableCopy;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import org.apache.commons.collections.primitives.DoubleCollection;
import org.apache.commons.collections.primitives.DoubleIterator;

public abstract class AbstractDoubleCollection
implements DoubleCollection {
    protected AbstractDoubleCollection() {
    }

    @Override
    @Nonnull
    public abstract DoubleIterator iterator();

    @Override
    @Nonnegative
    public abstract int size();

    @Override
    public boolean add(double d) {
        throw new UnsupportedOperationException("add(double) is not supported.");
    }

    @Override
    public boolean addAll(@Nonnull DoubleCollection doubleCollection) {
        boolean bl = false;
        DoubleIterator doubleIterator = doubleCollection.iterator();
        while (doubleIterator.hasNext()) {
            bl |= this.add(doubleIterator.next());
        }
        return bl;
    }

    @Override
    public void clear() {
        DoubleIterator doubleIterator = this.iterator();
        while (doubleIterator.hasNext()) {
            doubleIterator.next();
            doubleIterator.remove();
        }
    }

    @Override
    public boolean contains(double d) {
        DoubleIterator doubleIterator = this.iterator();
        while (doubleIterator.hasNext()) {
            if (doubleIterator.next() != d) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(@Nonnull DoubleCollection doubleCollection) {
        DoubleIterator doubleIterator = doubleCollection.iterator();
        while (doubleIterator.hasNext()) {
            if (this.contains(doubleIterator.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return 0 == this.size();
    }

    @Override
    public boolean removeElement(double d) {
        DoubleIterator doubleIterator = this.iterator();
        while (doubleIterator.hasNext()) {
            if (doubleIterator.next() != d) continue;
            doubleIterator.remove();
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(@Nonnull DoubleCollection doubleCollection) {
        boolean bl = false;
        DoubleIterator doubleIterator = doubleCollection.iterator();
        while (doubleIterator.hasNext()) {
            bl |= this.removeElement(doubleIterator.next());
        }
        return bl;
    }

    @Override
    public boolean retainAll(@Nonnull DoubleCollection doubleCollection) {
        boolean bl = false;
        DoubleIterator doubleIterator = this.iterator();
        while (doubleIterator.hasNext()) {
            if (doubleCollection.contains(doubleIterator.next())) continue;
            doubleIterator.remove();
            bl = true;
        }
        return bl;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public double[] toArray() {
        double[] dArray = new double[this.size()];
        int n = 0;
        DoubleIterator doubleIterator = this.iterator();
        while (doubleIterator.hasNext()) {
            dArray[n++] = doubleIterator.next();
        }
        return dArray;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public double[] toArray(@Nonnull double[] dArray) {
        if (dArray.length < this.size()) {
            return this.toArray();
        }
        int n = 0;
        DoubleIterator doubleIterator = this.iterator();
        while (doubleIterator.hasNext()) {
            dArray[n++] = doubleIterator.next();
        }
        return dArray;
    }
}

