/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives;

import com.phloc.commons.annotations.ReturnsMutableCopy;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import org.apache.commons.collections.primitives.ByteCollection;
import org.apache.commons.collections.primitives.ByteIterator;

public abstract class AbstractByteCollection
implements ByteCollection {
    protected AbstractByteCollection() {
    }

    @Override
    @Nonnull
    public abstract ByteIterator iterator();

    @Override
    @Nonnegative
    public abstract int size();

    @Override
    public boolean add(byte by) {
        throw new UnsupportedOperationException("add(byte) is not supported.");
    }

    @Override
    public boolean addAll(@Nonnull ByteCollection byteCollection) {
        boolean bl = false;
        ByteIterator byteIterator = byteCollection.iterator();
        while (byteIterator.hasNext()) {
            bl |= this.add(byteIterator.next());
        }
        return bl;
    }

    @Override
    public void clear() {
        ByteIterator byteIterator = this.iterator();
        while (byteIterator.hasNext()) {
            byteIterator.next();
            byteIterator.remove();
        }
    }

    @Override
    public boolean contains(byte by) {
        ByteIterator byteIterator = this.iterator();
        while (byteIterator.hasNext()) {
            if (byteIterator.next() != by) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(@Nonnull ByteCollection byteCollection) {
        ByteIterator byteIterator = byteCollection.iterator();
        while (byteIterator.hasNext()) {
            if (this.contains(byteIterator.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return 0 == this.size();
    }

    @Override
    public boolean removeElement(byte by) {
        ByteIterator byteIterator = this.iterator();
        while (byteIterator.hasNext()) {
            if (byteIterator.next() != by) continue;
            byteIterator.remove();
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(@Nonnull ByteCollection byteCollection) {
        boolean bl = false;
        ByteIterator byteIterator = byteCollection.iterator();
        while (byteIterator.hasNext()) {
            bl |= this.removeElement(byteIterator.next());
        }
        return bl;
    }

    @Override
    public boolean retainAll(@Nonnull ByteCollection byteCollection) {
        boolean bl = false;
        ByteIterator byteIterator = this.iterator();
        while (byteIterator.hasNext()) {
            if (byteCollection.contains(byteIterator.next())) continue;
            byteIterator.remove();
            bl = true;
        }
        return bl;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public byte[] toArray() {
        byte[] byArray = new byte[this.size()];
        int n = 0;
        ByteIterator byteIterator = this.iterator();
        while (byteIterator.hasNext()) {
            byArray[n++] = byteIterator.next();
        }
        return byArray;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public byte[] toArray(@Nonnull byte[] byArray) {
        if (byArray.length < this.size()) {
            return this.toArray();
        }
        int n = 0;
        ByteIterator byteIterator = this.iterator();
        while (byteIterator.hasNext()) {
            byArray[n++] = byteIterator.next();
        }
        return byArray;
    }
}

