/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.xml.xpath;

import com.phloc.commons.equals.EqualsUtils;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.string.ToStringGenerator;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathVariableResolver;

@NotThreadSafe
public class MapBasedXPathVariableResolver
implements XPathVariableResolver {
    private final Map<String, Object> m_aVars;

    public MapBasedXPathVariableResolver(@Nullable Map<String, Object> map) {
        this.m_aVars = map;
    }

    @Override
    @Nullable
    public Object resolveVariable(@Nonnull QName qName) {
        if (qName == null) {
            throw new NullPointerException("variableName");
        }
        if (this.m_aVars == null) {
            return null;
        }
        String string = qName.getLocalPart();
        return this.m_aVars.get(string);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        MapBasedXPathVariableResolver mapBasedXPathVariableResolver = (MapBasedXPathVariableResolver)object;
        return EqualsUtils.equals(this.m_aVars, mapBasedXPathVariableResolver.m_aVars);
    }

    public int hashCode() {
        return ((HashCodeGenerator)new HashCodeGenerator(this).append((Map)this.m_aVars)).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("vars", this.m_aVars).toString();
    }
}

