/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.xml.serialize;

import com.phloc.commons.CGlobal;
import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.io.streams.NonBlockingBufferedWriter;
import com.phloc.commons.io.streams.StreamUtils;
import com.phloc.commons.string.StringHelper;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.commons.xml.serialize.IXMLSerializer;
import com.phloc.commons.xml.serialize.IXMLWriterSettings;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillNotClose;
import javax.xml.namespace.NamespaceContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSerializerPhloc<NODETYPE>
implements IXMLSerializer<NODETYPE> {
    protected static final String NEWLINE = CGlobal.LINE_SEPARATOR;
    protected static final String INDENT = "  ";
    protected final IXMLWriterSettings m_aSettings;
    protected final StringBuilder m_aIndent = new StringBuilder(32);
    protected final NamespaceStack m_aNSStack;

    public AbstractSerializerPhloc(@Nonnull IXMLWriterSettings iXMLWriterSettings) {
        if (iXMLWriterSettings == null) {
            throw new NullPointerException("settings");
        }
        this.m_aSettings = iXMLWriterSettings;
        this.m_aNSStack = new NamespaceStack(iXMLWriterSettings.getNamespaceContext());
    }

    @Nonnull
    public final IXMLWriterSettings getSettings() {
        return this.m_aSettings;
    }

    @Override
    public final void write(@Nonnull NODETYPE NODETYPE, @Nonnull @WillNotClose OutputStream outputStream) {
        NonBlockingBufferedWriter nonBlockingBufferedWriter = new NonBlockingBufferedWriter(StreamUtils.createWriter(outputStream, this.m_aSettings.getCharsetObj()));
        this.write(NODETYPE, nonBlockingBufferedWriter);
    }

    public String toString() {
        return new ToStringGenerator(this).append("settings", this.m_aSettings).append("sIndent", this.m_aIndent.toString()).append("namespaceStack", this.m_aNSStack).toString();
    }

    protected static final class NamespaceStack {
        private final List<NamespaceLevel> m_aStack = new ArrayList<NamespaceLevel>();
        private final NamespaceContext m_aNamespaceCtx;

        public NamespaceStack(@Nullable NamespaceContext namespaceContext) {
            this.m_aNamespaceCtx = namespaceContext;
        }

        public void push(@Nullable Map<String, String> map) {
            NamespaceLevel namespaceLevel = new NamespaceLevel(map);
            this.m_aStack.add(0, namespaceLevel);
        }

        public void addNamespaceMapping(@Nullable String string, @Nonnull @Nonempty String string2) {
            this.m_aStack.get(0).addPrefixNamespaceMapping(string, string2);
        }

        public void pop() {
            this.m_aStack.remove(0);
        }

        @Nullable
        public String getDefaultNamespaceURI() {
            for (NamespaceLevel namespaceLevel : this.m_aStack) {
                String string = namespaceLevel.getDefaultNamespaceURI();
                if (!StringHelper.hasText(string)) continue;
                return string;
            }
            return null;
        }

        @Nullable
        public String getUsedPrefixOfNamespace(@Nonnull String string) {
            if (string == null) {
                throw new NullPointerException("namespaceURI");
            }
            for (NamespaceLevel namespaceLevel : this.m_aStack) {
                String string2 = namespaceLevel.getPrefixOfNamespaceURI(string);
                if (string2 == null) continue;
                return string2;
            }
            return null;
        }

        private boolean _containsAnyNamespace() {
            for (NamespaceLevel namespaceLevel : this.m_aStack) {
                if (!namespaceLevel.hasAnyNamespace()) continue;
                return true;
            }
            return false;
        }

        private boolean _containsPrefix(@Nonnull String string) {
            for (NamespaceLevel namespaceLevel : this.m_aStack) {
                if (namespaceLevel.getNamespaceURIOfPrefix(string) == null) continue;
                return true;
            }
            return false;
        }

        @Nullable
        public String getMappedPrefix(@Nonnull String string) {
            String string2;
            if (string == null) {
                throw new NullPointerException("namespaceURI");
            }
            if (this.m_aNamespaceCtx != null && (string2 = this.m_aNamespaceCtx.getPrefix(string)) != null) {
                return string2;
            }
            return null;
        }

        @Nullable
        public String createUniquePrefix() {
            if (!this._containsAnyNamespace()) {
                return null;
            }
            int n = 0;
            String string;
            while (this._containsPrefix(string = "ns" + n)) {
                ++n;
            }
            return string;
        }
    }

    protected static final class NamespaceLevel {
        private static final Logger s_aLogger = LoggerFactory.getLogger(NamespaceLevel.class);
        private String m_sDefaultNamespaceURI;
        private Map<String, String> m_aURL2PrefixMap;

        public NamespaceLevel(@Nullable Map<String, String> map) {
            if (map != null) {
                for (Map.Entry<String, String> entry : map.entrySet()) {
                    String string = entry.getKey();
                    if (string.equals("xmlns")) {
                        this.addPrefixNamespaceMapping(null, entry.getValue());
                        continue;
                    }
                    if (!string.startsWith("xmlns:")) continue;
                    this.addPrefixNamespaceMapping(string.substring("xmlns:".length()), entry.getValue());
                }
            }
        }

        @Nullable
        public String getNamespaceURIOfPrefix(@Nullable String string) {
            if (StringHelper.hasNoText(string)) {
                return this.m_sDefaultNamespaceURI;
            }
            if (this.m_aURL2PrefixMap != null) {
                for (Map.Entry<String, String> entry : this.m_aURL2PrefixMap.entrySet()) {
                    if (!entry.getValue().equals(string)) continue;
                    return entry.getKey();
                }
            }
            return null;
        }

        void addPrefixNamespaceMapping(@Nullable String string, @Nonnull @Nonempty String string2) {
            String string3;
            if (s_aLogger.isTraceEnabled()) {
                s_aLogger.trace("Adding namespace mapping " + string + ":" + string2);
            }
            if ((string3 = this.getNamespaceURIOfPrefix(string)) != null && !string3.equals(string2)) {
                s_aLogger.warn("Overwriting namespace prefix '" + string + "' to use URL '" + string2 + "' instead of '" + string3 + "'");
            }
            if (StringHelper.hasNoText(string)) {
                if (this.m_sDefaultNamespaceURI != null) {
                    s_aLogger.warn("Overwriting default namespace '" + this.m_sDefaultNamespaceURI + "' with namespace '" + string2 + "'");
                }
                this.m_sDefaultNamespaceURI = string2;
            } else {
                if (this.m_aURL2PrefixMap == null) {
                    this.m_aURL2PrefixMap = new HashMap<String, String>();
                }
                this.m_aURL2PrefixMap.put(string2, string);
            }
        }

        @Nullable
        public String getDefaultNamespaceURI() {
            return this.m_sDefaultNamespaceURI;
        }

        @Nullable
        public String getPrefixOfNamespaceURI(@Nonnull String string) {
            if (string.equals(this.m_sDefaultNamespaceURI)) {
                return null;
            }
            return this.m_aURL2PrefixMap == null ? null : this.m_aURL2PrefixMap.get(string);
        }

        @Nonnegative
        int getNamespaceCount() {
            return (this.m_sDefaultNamespaceURI == null ? 0 : 1) + (this.m_aURL2PrefixMap == null ? 0 : this.m_aURL2PrefixMap.size());
        }

        boolean hasAnyNamespace() {
            return this.m_sDefaultNamespaceURI != null || this.m_aURL2PrefixMap != null && !this.m_aURL2PrefixMap.isEmpty();
        }

        public String toString() {
            return new ToStringGenerator(this).append("defaultNSURI", this.m_sDefaultNamespaceURI).append("url2prefix", this.m_aURL2PrefixMap).toString();
        }
    }
}

