/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.xml.schema;

import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.error.IResourceErrorGroup;
import com.phloc.commons.io.IReadableResource;
import com.phloc.commons.xml.sax.CollectingSAXErrorHandler;
import com.phloc.commons.xml.schema.XMLSchemaCache;
import com.phloc.commons.xml.transform.TransformSourceFactory;
import javax.annotation.Nonnull;
import javax.xml.transform.Source;
import javax.xml.validation.Schema;
import javax.xml.validation.Validator;

public final class XMLSchemaValidationHelper {
    private static final XMLSchemaValidationHelper s_aInstance = new XMLSchemaValidationHelper();

    private XMLSchemaValidationHelper() {
    }

    @Nonnull
    public static IResourceErrorGroup validate(@Nonnull IReadableResource iReadableResource, @Nonnull IReadableResource iReadableResource2) {
        return XMLSchemaValidationHelper.validate(new IReadableResource[]{iReadableResource}, iReadableResource2);
    }

    @Nonnull
    public static IResourceErrorGroup validate(@Nonnull @Nonempty IReadableResource[] iReadableResourceArray, @Nonnull IReadableResource iReadableResource) {
        if (iReadableResource == null) {
            throw new NullPointerException("XMLresource");
        }
        return XMLSchemaValidationHelper.validate(iReadableResourceArray, (Source)TransformSourceFactory.create(iReadableResource));
    }

    @Nonnull
    public static IResourceErrorGroup validate(@Nonnull Schema schema, @Nonnull IReadableResource iReadableResource) {
        if (iReadableResource == null) {
            throw new NullPointerException("XMLresource");
        }
        return XMLSchemaValidationHelper.validate(schema, (Source)TransformSourceFactory.create(iReadableResource));
    }

    @Nonnull
    public static IResourceErrorGroup validate(@Nonnull @Nonempty IReadableResource iReadableResource, @Nonnull Source source) {
        return XMLSchemaValidationHelper.validate(new IReadableResource[]{iReadableResource}, source);
    }

    @Nonnull
    public static IResourceErrorGroup validate(@Nonnull @Nonempty IReadableResource[] iReadableResourceArray, @Nonnull Source source) {
        return XMLSchemaValidationHelper.validate(XMLSchemaCache.getInstance().getSchema(iReadableResourceArray), source);
    }

    @Nonnull
    public static IResourceErrorGroup validate(@Nonnull Schema schema, @Nonnull Source source) {
        if (schema == null) {
            throw new NullPointerException("schema");
        }
        if (source == null) {
            throw new NullPointerException("XMLsource");
        }
        Validator validator = schema.newValidator();
        CollectingSAXErrorHandler collectingSAXErrorHandler = new CollectingSAXErrorHandler();
        validator.setErrorHandler(collectingSAXErrorHandler);
        try {
            validator.validate(source, null);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Failed to validate the XML " + source + " against " + schema, exception);
        }
        return collectingSAXErrorHandler.getResourceErrors();
    }
}

