/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.url;

import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.commons.url.IURLProtocol;
import com.phloc.commons.url.URLProtocolRegistry;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class URLProtocol
implements IURLProtocol {
    private final String m_sProtocol;
    private final boolean m_bAllowsForQueryParameters;

    public URLProtocol(@Nonnull @Nonempty String string, boolean bl) {
        this.m_sProtocol = string;
        this.m_bAllowsForQueryParameters = bl;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getProtocol() {
        return this.m_sProtocol;
    }

    @Override
    public boolean isUsedInURL(@Nullable String string) {
        return string != null && string.startsWith(this.m_sProtocol);
    }

    @Override
    @Nullable
    public String getWithProtocol(@Nullable String string) {
        if (string == null) {
            return null;
        }
        return this.m_sProtocol + string;
    }

    @Override
    @Nullable
    public String getWithProtocolIfNone(@Nullable String string) {
        if (string == null || URLProtocolRegistry.hasKnownProtocol(string)) {
            return string;
        }
        return this.m_sProtocol + string;
    }

    @Override
    public boolean allowsForQueryParameters() {
        return this.m_bAllowsForQueryParameters;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        URLProtocol uRLProtocol = (URLProtocol)object;
        return this.m_sProtocol.equals(uRLProtocol.m_sProtocol) && this.m_bAllowsForQueryParameters == uRLProtocol.m_bAllowsForQueryParameters;
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_sProtocol).append(this.m_bAllowsForQueryParameters).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("protocol", this.m_sProtocol).append("queryParams", this.m_bAllowsForQueryParameters).toString();
    }
}

