/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.tree.withid;

import com.phloc.commons.annotations.OverrideOnDemand;
import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.equals.EqualsUtils;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.lang.GenericReflection;
import com.phloc.commons.state.EChange;
import com.phloc.commons.state.ESuccess;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.commons.tree.withid.ITreeItemWithID;
import com.phloc.commons.tree.withid.ITreeItemWithIDFactory;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class BasicTreeItemWithID<KEYTYPE, VALUETYPE, ITEMTYPE extends ITreeItemWithID<KEYTYPE, VALUETYPE, ITEMTYPE>>
implements ITreeItemWithID<KEYTYPE, VALUETYPE, ITEMTYPE> {
    private final ITreeItemWithIDFactory<KEYTYPE, VALUETYPE, ITEMTYPE> m_aFactory;
    private ITEMTYPE m_aParent;
    private final KEYTYPE m_aDataID;
    private VALUETYPE m_aData;
    private Map<KEYTYPE, ITEMTYPE> m_aChildMap = null;
    private List<ITEMTYPE> m_aChildren = null;

    public BasicTreeItemWithID(@Nonnull ITreeItemWithIDFactory<KEYTYPE, VALUETYPE, ITEMTYPE> iTreeItemWithIDFactory) {
        this(iTreeItemWithIDFactory, (null));
    }

    public BasicTreeItemWithID(@Nonnull ITreeItemWithIDFactory<KEYTYPE, VALUETYPE, ITEMTYPE> iTreeItemWithIDFactory, @Nullable KEYTYPE KEYTYPE) {
        if (iTreeItemWithIDFactory == null) {
            throw new NullPointerException("factory");
        }
        this.m_aFactory = iTreeItemWithIDFactory;
        this.m_aDataID = KEYTYPE;
    }

    public BasicTreeItemWithID(@Nonnull ITEMTYPE ITEMTYPE, @Nonnull KEYTYPE KEYTYPE) {
        if (ITEMTYPE == null) {
            throw new NullPointerException("parent");
        }
        if (!(ITEMTYPE instanceof BasicTreeItemWithID)) {
            throw new IllegalArgumentException("Parent is no BasicTreeItemWithID");
        }
        if (KEYTYPE == null) {
            throw new NullPointerException("dataID");
        }
        if (ITEMTYPE.getFactory() == null) {
            throw new IllegalStateException("Parent item has no factory!");
        }
        this.m_aParent = ITEMTYPE;
        this.m_aFactory = this.m_aParent.getFactory();
        this.m_aDataID = KEYTYPE;
    }

    @Override
    @Nonnull
    public final ITreeItemWithIDFactory<KEYTYPE, VALUETYPE, ITEMTYPE> getFactory() {
        return this.m_aFactory;
    }

    @OverrideOnDemand
    protected boolean isValidDataID(KEYTYPE KEYTYPE) {
        return true;
    }

    @OverrideOnDemand
    protected boolean isValidData(VALUETYPE VALUETYPE) {
        return true;
    }

    @Override
    public final boolean isRootItem() {
        return this.m_aParent == null;
    }

    @Nonnull
    private ITEMTYPE _asT(@Nonnull BasicTreeItemWithID<KEYTYPE, VALUETYPE, ITEMTYPE> basicTreeItemWithID) {
        return (ITEMTYPE)((ITreeItemWithID)GenericReflection.uncheckedCast(basicTreeItemWithID));
    }

    @Override
    @Nullable
    public final ITEMTYPE getParent() {
        return this.m_aParent;
    }

    @Override
    @Nullable
    public final KEYTYPE getID() {
        return this.m_aDataID;
    }

    @Override
    @Nullable
    public final VALUETYPE getData() {
        return this.m_aData;
    }

    @Override
    public final boolean hasChildren() {
        return this.m_aChildMap != null && !this.m_aChildMap.isEmpty();
    }

    @Override
    @Nonnegative
    public final int getChildCount() {
        return this.m_aChildMap == null ? 0 : this.m_aChildMap.size();
    }

    @Override
    @Nullable
    @ReturnsMutableCopy
    public final List<ITEMTYPE> getChildren() {
        return this.m_aChildren == null ? null : ContainerHelper.newList(this.m_aChildren);
    }

    @Override
    @Nullable
    public final ITEMTYPE getChildAtIndex(@Nonnegative int n) {
        if (this.m_aChildren == null) {
            throw new IndexOutOfBoundsException("Tree item has no children!");
        }
        return (ITEMTYPE)((ITreeItemWithID)this.m_aChildren.get(n));
    }

    @Override
    @Nullable
    public ITEMTYPE getFirstChild() {
        return (ITEMTYPE)((ITreeItemWithID)ContainerHelper.getFirstElement(this.m_aChildren));
    }

    @Override
    @Nullable
    public ITEMTYPE getLastChild() {
        return (ITEMTYPE)((ITreeItemWithID)ContainerHelper.getLastElement(this.m_aChildren));
    }

    @Override
    public final void setData(@Nullable VALUETYPE VALUETYPE) {
        if (!this.isValidData(VALUETYPE)) {
            throw new IllegalArgumentException("The passed data object is invalid!");
        }
        this.m_aData = VALUETYPE;
    }

    @Override
    @Nullable
    public final ITEMTYPE createChildItem(@Nullable KEYTYPE KEYTYPE, @Nullable VALUETYPE VALUETYPE) {
        return this.createChildItem(KEYTYPE, VALUETYPE, true);
    }

    @Override
    @Nullable
    public final ITEMTYPE createChildItem(@Nullable KEYTYPE KEYTYPE, @Nullable VALUETYPE VALUETYPE, boolean bl) {
        if (!this.isValidDataID(KEYTYPE)) {
            throw new IllegalArgumentException("Illegal data ID provided");
        }
        ITEMTYPE ITEMTYPE = this.getChildItemOfDataID(KEYTYPE);
        if (ITEMTYPE != null) {
            if (!bl) {
                return null;
            }
            ITEMTYPE.setData(VALUETYPE);
        } else {
            ITEMTYPE = this.m_aFactory.create(this._asT(this), KEYTYPE);
            if (ITEMTYPE == null) {
                throw new IllegalStateException("null item created!");
            }
            ITEMTYPE.setData(VALUETYPE);
            if (this.m_aChildMap == null) {
                this.m_aChildMap = new HashMap<KEYTYPE, ITEMTYPE>();
                this.m_aChildren = new ArrayList<ITEMTYPE>();
            }
            this.m_aChildMap.put(KEYTYPE, ITEMTYPE);
            this.m_aChildren.add(ITEMTYPE);
        }
        return ITEMTYPE;
    }

    @Override
    @Nullable
    public final ITEMTYPE getChildItemOfDataID(@Nullable KEYTYPE KEYTYPE) {
        return (ITEMTYPE)(this.m_aChildMap == null ? null : (ITreeItemWithID)this.m_aChildMap.get(KEYTYPE));
    }

    @Override
    @SuppressFBWarnings(value={"IL_INFINITE_LOOP"})
    public final boolean isSameOrChildOf(@Nonnull ITEMTYPE ITEMTYPE) {
        if (ITEMTYPE == null) {
            throw new NullPointerException("parent");
        }
        for (ITreeItemWithID<KEYTYPE, VALUETYPE, ITEMTYPE> iTreeItemWithID = this; iTreeItemWithID != null; iTreeItemWithID = (ITreeItemWithID)iTreeItemWithID.getParent()) {
            if (iTreeItemWithID != ITEMTYPE) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nonnull
    public final ESuccess changeParent(@Nonnull ITEMTYPE ITEMTYPE) {
        if (ITEMTYPE == null) {
            throw new NullPointerException("newParent");
        }
        if (this.getParent() == ITEMTYPE) {
            return ESuccess.SUCCESS;
        }
        ITEMTYPE ITEMTYPE2 = this._asT(this);
        if (ITEMTYPE.isSameOrChildOf(ITEMTYPE2)) {
            return ESuccess.FAILURE;
        }
        if (this.m_aParent.removeChild(this.getID()).isUnchanged()) {
            throw new IllegalStateException("Failed to remove this from parent!");
        }
        this.m_aParent = ITEMTYPE;
        return ESuccess.valueOfChange(ITEMTYPE.internalAddChild(this.getID(), ITEMTYPE2, false));
    }

    @Override
    @Nonnull
    public final EChange internalAddChild(@Nonnull KEYTYPE KEYTYPE, @Nonnull ITEMTYPE ITEMTYPE, boolean bl) {
        if (ITEMTYPE == null) {
            throw new NullPointerException("child");
        }
        if (this.m_aChildMap != null) {
            if (!bl && this.m_aChildMap.containsKey(KEYTYPE)) {
                return EChange.UNCHANGED;
            }
        } else {
            this.m_aChildMap = new HashMap<KEYTYPE, ITEMTYPE>();
            this.m_aChildren = new ArrayList<ITEMTYPE>();
        }
        this.m_aChildMap.put(KEYTYPE, ITEMTYPE);
        this.m_aChildren.add(ITEMTYPE);
        this.m_aFactory.onAddItem(ITEMTYPE);
        return EChange.CHANGED;
    }

    @Override
    @Nonnull
    public final EChange removeChild(@Nonnull KEYTYPE KEYTYPE) {
        if (KEYTYPE == null) {
            throw new NullPointerException("dataID");
        }
        if (this.m_aChildMap == null) {
            return EChange.UNCHANGED;
        }
        ITreeItemWithID iTreeItemWithID = (ITreeItemWithID)this.m_aChildMap.remove(KEYTYPE);
        if (iTreeItemWithID == null) {
            return EChange.UNCHANGED;
        }
        if (!this.m_aChildren.remove(iTreeItemWithID)) {
            throw new IllegalStateException("Failed to remove item from list: " + iTreeItemWithID);
        }
        this.m_aFactory.onRemoveItem(iTreeItemWithID);
        return EChange.CHANGED;
    }

    @Override
    @Nonnull
    public final EChange removeAllChildren() {
        if (this.m_aChildMap == null || this.m_aChildMap.isEmpty()) {
            return EChange.UNCHANGED;
        }
        ArrayList<ITEMTYPE> arrayList = new ArrayList<ITEMTYPE>(this.m_aChildren);
        this.m_aChildMap.clear();
        this.m_aChildren.clear();
        for (ITreeItemWithID iTreeItemWithID : arrayList) {
            this.m_aFactory.onRemoveItem(iTreeItemWithID);
        }
        return EChange.CHANGED;
    }

    @Override
    public final void reorderChildrenByItems(@Nonnull Comparator<? super ITEMTYPE> comparator) {
        if (this.m_aChildren != null) {
            ContainerHelper.getSortedInline(this.m_aChildren, comparator);
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        BasicTreeItemWithID basicTreeItemWithID = (BasicTreeItemWithID)object;
        return EqualsUtils.equals(this.m_aDataID, basicTreeItemWithID.m_aDataID) && EqualsUtils.equals(this.m_aData, basicTreeItemWithID.m_aData) && EqualsUtils.equals(this.m_aChildMap, basicTreeItemWithID.m_aChildMap);
    }

    public int hashCode() {
        return ((HashCodeGenerator)new HashCodeGenerator(this).append(this.m_aData).append(this.m_aDataID).append((Map)this.m_aChildMap)).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("dataID", this.m_aDataID).append("data", this.m_aData).append("children", this.m_aChildMap).toString();
    }
}

