/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.text.utils;

import com.phloc.commons.string.StringHelper;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class RomanNumeral {
    public static final int MIN_VAL = 1;
    public static final int MAX_VAL = 3999;
    private static final int[] NUMBERS = new int[]{1000, 900, 500, 400, 100, 90, 50, 40, 10, 9, 5, 4, 1};
    private static final String[] ROMAN_LETTERS = new String[]{"M", "CM", "D", "CD", "C", "XC", "L", "XL", "X", "IX", "V", "IV", "I"};
    private final int m_nValue;

    private RomanNumeral(@Nonnegative int n) {
        if (n < 1 || n > 3999) {
            throw new IllegalArgumentException("Value of RomanNumeral must be between 1 and 3999.");
        }
        this.m_nValue = n;
    }

    private RomanNumeral(@Nonnull String string) {
        if (StringHelper.hasNoText(string)) {
            throw new IllegalArgumentException("An empty string does not define a Roman numeral.");
        }
        String string2 = string.toUpperCase();
        int n = 0;
        int n2 = 0;
        while (n < string2.length()) {
            char c = string2.charAt(n);
            int n3 = RomanNumeral._letterToNumber(c);
            if (++n == string2.length()) {
                n2 += n3;
                continue;
            }
            int n4 = RomanNumeral._letterToNumber(string2.charAt(n));
            if (n4 > n3) {
                n2 += n4 - n3;
                ++n;
                continue;
            }
            n2 += n3;
        }
        if (n2 > 3999) {
            throw new IllegalArgumentException("Roman numeral must have value 3999 or less.");
        }
        this.m_nValue = n2;
    }

    @Nonnegative
    private static int _letterToNumber(char c) {
        switch (c) {
            case 'I': {
                return 1;
            }
            case 'V': {
                return 5;
            }
            case 'X': {
                return 10;
            }
            case 'L': {
                return 50;
            }
            case 'C': {
                return 100;
            }
            case 'D': {
                return 500;
            }
            case 'M': {
                return 1000;
            }
        }
        throw new IllegalArgumentException("Unknown roman numeral char: " + c);
    }

    @Nonnull
    private static String _asRomanString(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = n;
        for (int i = 0; i < NUMBERS.length; ++i) {
            while (n2 >= NUMBERS[i]) {
                stringBuilder.append(ROMAN_LETTERS[i]);
                n2 -= NUMBERS[i];
            }
        }
        return stringBuilder.toString();
    }

    @Nonnull
    private String _asRomanString() {
        return RomanNumeral._asRomanString(this.m_nValue);
    }

    private int _asInt() {
        return this.m_nValue;
    }

    @Nonnegative
    public static int romanStringToInt(String string) {
        return new RomanNumeral(string)._asInt();
    }

    @Nonnull
    public static String intToRomanString(int n) {
        return new RomanNumeral(n)._asRomanString();
    }
}

