/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.text.resolve;

import com.phloc.commons.lang.EnumHelper;
import com.phloc.commons.stats.IStatisticsHandlerCounter;
import com.phloc.commons.stats.IStatisticsHandlerKeyedCounter;
import com.phloc.commons.stats.StatisticsManager;
import com.phloc.commons.text.ITextProvider;
import com.phloc.commons.text.impl.TextFormatter;
import com.phloc.commons.text.resolve.IEnumTextResolver;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public abstract class AbstractEnumTextResolverWithOverrideAndFallback
implements IEnumTextResolver {
    private static final IStatisticsHandlerKeyedCounter s_aStatsGetText = StatisticsManager.getKeyedCounterHandler(AbstractEnumTextResolverWithOverrideAndFallback.class.getName() + "$getText");
    private static final IStatisticsHandlerKeyedCounter s_aStatsGetTextWithArgs = StatisticsManager.getKeyedCounterHandler(AbstractEnumTextResolverWithOverrideAndFallback.class.getName() + "$getTextWithArgs");
    private static final IStatisticsHandlerCounter s_aStatsOverride = StatisticsManager.getCounterHandler(AbstractEnumTextResolverWithOverrideAndFallback.class.getName() + "$OVERRIDE");
    private static final IStatisticsHandlerCounter s_aStatsFallback = StatisticsManager.getCounterHandler(AbstractEnumTextResolverWithOverrideAndFallback.class.getName() + "$FALLBACK");

    @Nullable
    protected abstract String internalGetOverrideString(@Nonnull String var1, @Nonnull Locale var2);

    @Nullable
    protected abstract String internalGetFallbackString(@Nonnull String var1, @Nonnull Locale var2);

    @Nullable
    private String _getText(@Nonnull Enum<?> enum_, @Nonnull ITextProvider iTextProvider, @Nonnull Locale locale, boolean bl) {
        String string = EnumHelper.getEnumID(enum_);
        (bl ? s_aStatsGetTextWithArgs : s_aStatsGetText).increment(string);
        String string2 = this.internalGetOverrideString(string, locale);
        if (string2 != null) {
            s_aStatsOverride.increment();
        } else {
            string2 = iTextProvider.getTextWithLocaleFallback(locale);
            if (string2 == null) {
                s_aStatsFallback.increment();
                string2 = this.internalGetFallbackString(string, locale);
            }
        }
        return string2;
    }

    @Override
    @Nullable
    public final String getText(@Nonnull Enum<?> enum_, @Nonnull ITextProvider iTextProvider, @Nonnull Locale locale) {
        return this._getText(enum_, iTextProvider, locale, false);
    }

    @Override
    @Nullable
    public final String getTextWithArgs(@Nonnull Enum<?> enum_, @Nonnull ITextProvider iTextProvider, @Nonnull Locale locale, Object ... objectArray) {
        String string = this._getText(enum_, iTextProvider, locale, true);
        return TextFormatter.getFormattedText(string, objectArray);
    }
}

