/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.mutable;

import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.mutable.IMutableInteger;
import com.phloc.commons.state.EChange;
import com.phloc.commons.string.ToStringGenerator;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class MutableChar
extends Number
implements IMutableInteger<MutableChar> {
    public static final char DEFAULT_VALUE = '\u0000';
    private char m_cValue;

    public MutableChar() {
        this('\u0000');
    }

    public MutableChar(int n) {
        this((char)n);
    }

    public MutableChar(@Nonnull Character c) {
        this(c.charValue());
    }

    public MutableChar(char c) {
        this.m_cValue = c;
    }

    public char charValue() {
        return this.m_cValue;
    }

    @Nonnull
    public Character getAsCharacter() {
        return Character.valueOf(this.m_cValue);
    }

    @Override
    public float floatValue() {
        return this.m_cValue;
    }

    @Override
    public double doubleValue() {
        return this.m_cValue;
    }

    @Override
    public int intValue() {
        return this.m_cValue;
    }

    @Override
    public long longValue() {
        return this.m_cValue;
    }

    public int inc() {
        return this.inc(1);
    }

    public int inc(int n) {
        this.m_cValue = (char)(this.m_cValue + n);
        return this.m_cValue;
    }

    public int dec() {
        return this.inc(-1);
    }

    public int dec(int n) {
        return this.inc(-n);
    }

    @Nonnull
    public EChange set(int n) {
        return this.set((char)n);
    }

    @Nonnull
    public EChange set(char c) {
        if (this.m_cValue == c) {
            return EChange.UNCHANGED;
        }
        this.m_cValue = c;
        return EChange.CHANGED;
    }

    @Override
    public boolean is0() {
        return this.m_cValue == '\u0000';
    }

    @Override
    public boolean isNot0() {
        return this.m_cValue != '\u0000';
    }

    @Override
    public boolean isSmaller0() {
        return this.m_cValue < '\u0000';
    }

    @Override
    public boolean isSmallerOrEqual0() {
        return this.m_cValue <= '\u0000';
    }

    @Override
    public boolean isGreater0() {
        return this.m_cValue > '\u0000';
    }

    @Override
    public boolean isGreaterOrEqual0() {
        return this.m_cValue >= '\u0000';
    }

    @Override
    public boolean isEven() {
        return this.m_cValue % 2 == 0;
    }

    @Override
    public boolean isOdd() {
        return this.m_cValue % 2 != 0;
    }

    @Override
    public int compareTo(MutableChar mutableChar) {
        return this.m_cValue == mutableChar.m_cValue ? 0 : (this.m_cValue < mutableChar.m_cValue ? -1 : 1);
    }

    @Override
    @Nonnull
    public MutableChar getClone() {
        return new MutableChar(this.m_cValue);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof MutableChar)) {
            return false;
        }
        MutableChar mutableChar = (MutableChar)object;
        return this.m_cValue == mutableChar.m_cValue;
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_cValue).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("value", this.m_cValue).toString();
    }
}

