/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.microdom.serialize;

import com.phloc.commons.io.streams.StreamUtils;
import com.phloc.commons.microdom.IMicroCDATA;
import com.phloc.commons.microdom.IMicroComment;
import com.phloc.commons.microdom.IMicroContainer;
import com.phloc.commons.microdom.IMicroDocument;
import com.phloc.commons.microdom.IMicroDocumentType;
import com.phloc.commons.microdom.IMicroElement;
import com.phloc.commons.microdom.IMicroEntityReference;
import com.phloc.commons.microdom.IMicroNode;
import com.phloc.commons.microdom.IMicroProcessingInstruction;
import com.phloc.commons.microdom.IMicroText;
import com.phloc.commons.string.StringHelper;
import com.phloc.commons.xml.IXMLIterationHandler;
import com.phloc.commons.xml.serialize.AbstractSerializerPhloc;
import com.phloc.commons.xml.serialize.IXMLWriterSettings;
import com.phloc.commons.xml.serialize.XMLEmitterPhloc;
import com.phloc.commons.xml.serialize.XMLWriterSettings;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillNotClose;

public final class MicroSerializer
extends AbstractSerializerPhloc<IMicroNode> {
    public MicroSerializer() {
        this(XMLWriterSettings.DEFAULT_XML_SETTINGS);
    }

    public MicroSerializer(@Nonnull IXMLWriterSettings iXMLWriterSettings) {
        super(iXMLWriterSettings);
    }

    private void _writeNode(@Nonnull IXMLIterationHandler iXMLIterationHandler, @Nullable IMicroNode iMicroNode, @Nonnull IMicroNode iMicroNode2, @Nullable IMicroNode iMicroNode3) {
        if (iMicroNode2 == null) {
            throw new NullPointerException("node");
        }
        if (iMicroNode2.isElement()) {
            this._writeElement(iXMLIterationHandler, iMicroNode, (IMicroElement)iMicroNode2, iMicroNode3);
        } else if (iMicroNode2.isText()) {
            MicroSerializer._writeText(iXMLIterationHandler, (IMicroText)iMicroNode2);
        } else if (iMicroNode2.isCDATA()) {
            MicroSerializer._writeCDATA(iXMLIterationHandler, (IMicroCDATA)iMicroNode2);
        } else if (iMicroNode2.isComment()) {
            this._writeComment(iXMLIterationHandler, (IMicroComment)iMicroNode2);
        } else if (iMicroNode2.isEntityReference()) {
            MicroSerializer._writeEntityReference(iXMLIterationHandler, (IMicroEntityReference)iMicroNode2);
        } else if (iMicroNode2.isDocument()) {
            this._writeDocument(iXMLIterationHandler, (IMicroDocument)iMicroNode2);
        } else if (iMicroNode2.isDocumentType()) {
            this._writeDocumentType(iXMLIterationHandler, (IMicroDocumentType)iMicroNode2);
        } else if (iMicroNode2.isProcessingInstruction()) {
            MicroSerializer._writeProcessingInstruction(iXMLIterationHandler, (IMicroProcessingInstruction)iMicroNode2);
        } else if (iMicroNode2.isContainer()) {
            this._writeContainer(iXMLIterationHandler, (IMicroContainer)iMicroNode2);
        } else {
            throw new IllegalArgumentException("Passed node type " + iMicroNode2.getClass().getName() + " is not yet supported");
        }
    }

    private void _writeNodeList(@Nonnull IXMLIterationHandler iXMLIterationHandler, @Nonnull List<IMicroNode> list) {
        int n = list.size() - 1;
        for (int i = 0; i <= n; ++i) {
            this._writeNode(iXMLIterationHandler, i == 0 ? null : list.get(i - 1), list.get(i), i == n ? null : list.get(i + 1));
        }
    }

    private void _writeDocument(@Nonnull IXMLIterationHandler iXMLIterationHandler, IMicroDocument iMicroDocument) {
        if (this.m_aSettings.getFormat().isXML()) {
            iXMLIterationHandler.onDocumentStart(this.m_aSettings.getXMLVersion(), this.m_aSettings.getCharset(), iMicroDocument.isStandalone());
        }
        if (iMicroDocument.hasChildren()) {
            this._writeNodeList(iXMLIterationHandler, iMicroDocument.getChildren());
        }
    }

    private void _writeDocumentType(@Nonnull IXMLIterationHandler iXMLIterationHandler, IMicroDocumentType iMicroDocumentType) {
        if (this.m_aSettings.getSerializeDocType().emit()) {
            iXMLIterationHandler.onDocumentType(iMicroDocumentType.getQualifiedName(), iMicroDocumentType.getPublicID(), iMicroDocumentType.getSystemID());
        }
    }

    private static void _writeProcessingInstruction(@Nonnull IXMLIterationHandler iXMLIterationHandler, IMicroProcessingInstruction iMicroProcessingInstruction) {
        iXMLIterationHandler.onProcessingInstruction(iMicroProcessingInstruction.getTarget(), iMicroProcessingInstruction.getData());
    }

    private void _writeContainer(@Nonnull IXMLIterationHandler iXMLIterationHandler, IMicroContainer iMicroContainer) {
        if (iMicroContainer.hasChildren()) {
            this._writeNodeList(iXMLIterationHandler, iMicroContainer.getChildren());
        }
    }

    private static void _writeEntityReference(@Nonnull IXMLIterationHandler iXMLIterationHandler, @Nonnull IMicroEntityReference iMicroEntityReference) {
        iXMLIterationHandler.onEntityReference(iMicroEntityReference.getName());
    }

    private static void _writeText(@Nonnull IXMLIterationHandler iXMLIterationHandler, @Nonnull IMicroText iMicroText) {
        iXMLIterationHandler.onText(((Object)iMicroText.getData()).toString(), iMicroText.isEscape());
    }

    private void _writeComment(@Nonnull IXMLIterationHandler iXMLIterationHandler, @Nonnull IMicroComment iMicroComment) {
        if (this.m_aSettings.getSerializeComments().emit()) {
            if (this.m_aSettings.getIndent().isIndent() && this.m_aIndent.length() > 0) {
                iXMLIterationHandler.onContentElementWhitespace(this.m_aIndent);
            }
            iXMLIterationHandler.onComment(((Object)iMicroComment.getData()).toString());
            if (this.m_aSettings.getIndent().isAlign()) {
                iXMLIterationHandler.onContentElementWhitespace(NEWLINE);
            }
        }
    }

    private static void _writeCDATA(@Nonnull IXMLIterationHandler iXMLIterationHandler, @Nonnull IMicroCDATA iMicroCDATA) {
        iXMLIterationHandler.onCDATA(((Object)iMicroCDATA.getData()).toString());
    }

    private static boolean _isInlineNode(@Nonnull IMicroNode iMicroNode) {
        return (iMicroNode.isText() || iMicroNode.isCDATA()) && !iMicroNode.isComment() || iMicroNode.isEntityReference();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _writeElement(@Nonnull IXMLIterationHandler iXMLIterationHandler, @Nullable IMicroNode iMicroNode, @Nonnull IMicroElement iMicroElement, @Nullable IMicroNode iMicroNode2) {
        String string = iMicroElement.getLocalName() != null ? iMicroElement.getLocalName() : iMicroElement.getTagName();
        List<IMicroNode> list = iMicroElement.getChildren();
        boolean bl = iMicroElement.hasChildren();
        boolean bl2 = iMicroElement.getParent() != null && iMicroElement.getParent().isDocument();
        boolean bl3 = iMicroNode == null || !MicroSerializer._isInlineNode(iMicroNode) || bl2;
        boolean bl4 = iMicroNode2 == null || !MicroSerializer._isInlineNode(iMicroNode2);
        boolean bl5 = bl && !MicroSerializer._isInlineNode(iMicroElement.getFirstChild());
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        if (iMicroElement.hasAttributes()) {
            linkedHashMap.putAll(iMicroElement.getAttributes());
        }
        this.m_aNSStack.push(linkedHashMap);
        try {
            String string2;
            String string3 = StringHelper.getNotNull(iMicroElement.getNamespaceURI());
            String string4 = StringHelper.getNotNull(this.m_aNSStack.getDefaultNamespaceURI());
            boolean bl6 = string3.equals(string4);
            String string5 = string2 = bl6 ? null : this.m_aNSStack.getUsedPrefixOfNamespace(string3);
            if (!(string2 != null || bl6 || bl2 && string3.length() <= 0)) {
                string2 = this.m_aNSStack.getMappedPrefix(string3);
                if (string2 == null && !bl2) {
                    string2 = this.m_aNSStack.createUniquePrefix();
                }
                if (StringHelper.hasNoText(string2)) {
                    linkedHashMap.put("xmlns", string3);
                } else {
                    linkedHashMap.put("xmlns:" + string2, string3);
                }
                this.m_aNSStack.addNamespaceMapping(string2, string3);
            }
            if (this.m_aSettings.getIndent().isIndent() && bl3 && this.m_aIndent.length() > 0) {
                iXMLIterationHandler.onContentElementWhitespace(this.m_aIndent);
            }
            iXMLIterationHandler.onElementStart(string2, string, linkedHashMap, bl);
            if (bl) {
                if (this.m_aSettings.getIndent().isAlign() && bl5) {
                    iXMLIterationHandler.onContentElementWhitespace(NEWLINE);
                }
                this.m_aIndent.append("  ");
                if (list != null) {
                    this._writeNodeList(iXMLIterationHandler, list);
                }
                this.m_aIndent.delete(this.m_aIndent.length() - "  ".length(), this.m_aIndent.length());
                if (this.m_aSettings.getIndent().isIndent() && bl5 && this.m_aIndent.length() > 0) {
                    iXMLIterationHandler.onContentElementWhitespace(this.m_aIndent);
                }
            }
            iXMLIterationHandler.onElementEnd(string2, string, bl);
            if (this.m_aSettings.getIndent().isAlign() && bl4) {
                iXMLIterationHandler.onContentElementWhitespace(NEWLINE);
            }
        }
        finally {
            this.m_aNSStack.pop();
        }
    }

    @Override
    public void write(@Nonnull IMicroNode iMicroNode, @Nonnull @WillNotClose Writer writer) {
        XMLEmitterPhloc xMLEmitterPhloc = new XMLEmitterPhloc(writer, this.m_aSettings);
        this._writeNode(xMLEmitterPhloc, null, iMicroNode, null);
        StreamUtils.flush(writer);
    }

    public void write(@Nonnull IMicroNode iMicroNode, @Nonnull IXMLIterationHandler iXMLIterationHandler) {
        this._writeNode(iXMLIterationHandler, null, iMicroNode, null);
    }
}

