/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.microdom.impl;

import com.phloc.commons.GlobalDebug;
import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.equals.EqualsUtils;
import com.phloc.commons.microdom.EMicroNodeType;
import com.phloc.commons.microdom.IMicroElement;
import com.phloc.commons.microdom.IMicroNode;
import com.phloc.commons.microdom.IMicroText;
import com.phloc.commons.microdom.impl.AbstractMicroNodeWithChildren;
import com.phloc.commons.state.EChange;
import com.phloc.commons.string.StringHelper;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.commons.typeconvert.TypeConverter;
import com.phloc.commons.xml.CXMLRegEx;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class MicroElement
extends AbstractMicroNodeWithChildren
implements IMicroElement {
    private String m_sNamespaceURI;
    private final String m_sTagName;
    private Map<String, String> m_aAttrs;

    public MicroElement(@Nonnull @Nonempty String string) {
        this(null, string);
    }

    public MicroElement(@Nullable String string, @Nonnull @Nonempty String string2) {
        if (StringHelper.hasNoText(string2)) {
            throw new IllegalArgumentException("No valid tag name specified");
        }
        this.m_sNamespaceURI = string;
        int n = string != null ? string2.indexOf(58) : -1;
        String string3 = this.m_sTagName = n == -1 ? string2 : string2.substring(n + 1);
        if (GlobalDebug.isDebugMode() && !CXMLRegEx.PATTERN_NAME.matcher(this.m_sTagName).matches()) {
            throw new IllegalArgumentException("The passed element name '" + this.m_sTagName + "' is not a valid element name!");
        }
    }

    @Override
    @Nonnull
    public EMicroNodeType getType() {
        return EMicroNodeType.ELEMENT;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getNodeName() {
        return this.m_sTagName;
    }

    @Override
    public boolean hasAttributes() {
        return this.m_aAttrs != null && !this.m_aAttrs.isEmpty();
    }

    @Override
    @Nullable
    @ReturnsMutableCopy
    public Map<String, String> getAttributes() {
        return this.hasAttributes() ? ContainerHelper.newOrderedMap(this.m_aAttrs) : null;
    }

    @Override
    @Nullable
    public String getAttribute(@Nullable String string) {
        return this.m_aAttrs == null ? null : this.m_aAttrs.get(string);
    }

    @Override
    @Nullable
    public <DSTTYPE> DSTTYPE getAttributeWithConversion(@Nullable String string, @Nonnull Class<DSTTYPE> clazz) {
        String string2 = this.getAttribute(string);
        if (StringHelper.hasNoText(string2)) {
            return null;
        }
        DSTTYPE DSTTYPE = TypeConverter.convertIfNecessary(string2, clazz);
        return DSTTYPE;
    }

    @Override
    public boolean hasAttribute(@Nullable String string) {
        return this.m_aAttrs != null && this.m_aAttrs.containsKey(string);
    }

    @Override
    @Nonnull
    public EChange removeAttribute(@Nullable String string) {
        return EChange.valueOf(this.m_aAttrs != null && this.m_aAttrs.remove(string) != null);
    }

    @Override
    @Nonnull
    public IMicroElement setAttribute(@Nonnull @Nonempty String string, @Nullable String string2) {
        if (StringHelper.hasNoText(string)) {
            throw new IllegalArgumentException("No valid attribute name passed");
        }
        if (GlobalDebug.isDebugMode() && !CXMLRegEx.PATTERN_NAME.matcher(string).matches()) {
            throw new IllegalArgumentException("The passed attribute name '" + string + "' is not a valid attribute name!");
        }
        if (string2 != null) {
            if (this.m_aAttrs == null) {
                this.m_aAttrs = new LinkedHashMap<String, String>();
            }
            this.m_aAttrs.put(string, string2);
        } else {
            this.removeAttribute(string);
        }
        return this;
    }

    @Override
    @Nonnull
    public IMicroElement setAttribute(@Nonnull String string, int n) {
        return this.setAttribute(string, Integer.toString(n));
    }

    @Override
    @Nonnull
    public IMicroElement setAttribute(@Nonnull String string, long l) {
        return this.setAttribute(string, Long.toString(l));
    }

    @Override
    @Nonnull
    public IMicroElement setAttributeWithConversion(@Nonnull String string, @Nullable Object object) {
        String string2 = TypeConverter.convertIfNecessary(object, String.class);
        return this.setAttribute(string, string2);
    }

    @Override
    @Nonnull
    public EChange removeAllAttributes() {
        if (ContainerHelper.isEmpty(this.m_aAttrs)) {
            return EChange.UNCHANGED;
        }
        this.m_aAttrs.clear();
        return EChange.CHANGED;
    }

    @Override
    @Nullable
    public String getNamespaceURI() {
        return this.m_sNamespaceURI;
    }

    @Override
    public boolean hasNamespaceURI(@Nullable String string) {
        return EqualsUtils.equals(this.m_sNamespaceURI, string);
    }

    @Override
    @Nonnull
    public EChange setNamespaceURI(@Nullable String string) {
        if (EqualsUtils.equals(this.m_sNamespaceURI, string)) {
            return EChange.UNCHANGED;
        }
        this.m_sNamespaceURI = string;
        return EChange.CHANGED;
    }

    @Override
    @Nullable
    public String getLocalName() {
        return this.m_sNamespaceURI == null ? null : this.m_sTagName;
    }

    @Override
    @Nonnull
    public String getTagName() {
        return this.m_sTagName;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public List<IMicroElement> getChildElements() {
        ArrayList<IMicroElement> arrayList = new ArrayList<IMicroElement>();
        if (this.hasChildren()) {
            for (IMicroNode iMicroNode : this.directGetChildren()) {
                if (iMicroNode.isElement()) {
                    arrayList.add((IMicroElement)iMicroNode);
                    continue;
                }
                if (!iMicroNode.isContainer() || !iMicroNode.hasChildren()) continue;
                for (IMicroNode iMicroNode2 : iMicroNode.getChildren()) {
                    if (!iMicroNode2.isElement()) continue;
                    arrayList.add((IMicroElement)iMicroNode2);
                }
            }
        }
        return arrayList;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public List<IMicroElement> getChildElements(@Nullable String string) {
        ArrayList<IMicroElement> arrayList = new ArrayList<IMicroElement>();
        if (this.hasChildren()) {
            for (IMicroNode iMicroNode : this.directGetChildren()) {
                if (iMicroNode.isElement()) {
                    IMicroElement iMicroElement = (IMicroElement)iMicroNode;
                    if (!iMicroElement.getTagName().equals(string)) continue;
                    arrayList.add(iMicroElement);
                    continue;
                }
                if (!iMicroNode.isContainer() || !iMicroNode.hasChildren()) continue;
                for (IMicroNode iMicroNode2 : iMicroNode.getChildren()) {
                    IMicroElement iMicroElement;
                    if (!iMicroNode2.isElement() || !(iMicroElement = (IMicroElement)iMicroNode2).getTagName().equals(string)) continue;
                    arrayList.add(iMicroElement);
                }
            }
        }
        return arrayList;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public List<IMicroElement> getChildElements(@Nullable String string, @Nullable String string2) {
        if (StringHelper.hasNoText(string)) {
            return this.getChildElements(string2);
        }
        ArrayList<IMicroElement> arrayList = new ArrayList<IMicroElement>();
        if (this.hasChildren()) {
            for (IMicroNode iMicroNode : this.directGetChildren()) {
                if (iMicroNode.isElement()) {
                    IMicroElement iMicroElement = (IMicroElement)iMicroNode;
                    if (!iMicroElement.hasNamespaceURI(string) || !iMicroElement.getLocalName().equals(string2)) continue;
                    arrayList.add(iMicroElement);
                    continue;
                }
                if (!iMicroNode.isContainer() || !iMicroNode.hasChildren()) continue;
                for (IMicroNode iMicroNode2 : iMicroNode.getChildren()) {
                    IMicroElement iMicroElement;
                    if (!iMicroNode2.isElement() || !(iMicroElement = (IMicroElement)iMicroNode2).hasNamespaceURI(string) || !iMicroElement.getLocalName().equals(string2)) continue;
                    arrayList.add(iMicroElement);
                }
            }
        }
        return arrayList;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public List<IMicroElement> getAllChildElementsRecursive() {
        ArrayList<IMicroElement> arrayList = new ArrayList<IMicroElement>();
        if (this.hasChildren()) {
            for (IMicroNode iMicroNode : this.directGetChildren()) {
                if (iMicroNode.isElement()) {
                    IMicroElement iMicroElement = (IMicroElement)iMicroNode;
                    arrayList.add(iMicroElement);
                    arrayList.addAll(iMicroElement.getAllChildElementsRecursive());
                    continue;
                }
                if (!iMicroNode.isContainer() || !iMicroNode.hasChildren()) continue;
                for (IMicroNode iMicroNode2 : iMicroNode.getChildren()) {
                    if (!iMicroNode2.isElement()) continue;
                    MicroElement microElement = (MicroElement)iMicroNode2;
                    arrayList.add(microElement);
                    arrayList.addAll(microElement.getAllChildElementsRecursive());
                }
            }
        }
        return arrayList;
    }

    @Override
    public boolean hasChildElements() {
        if (this.hasChildren()) {
            for (IMicroNode iMicroNode : this.directGetChildren()) {
                if (iMicroNode.isElement()) {
                    return true;
                }
                if (!iMicroNode.isContainer() || !iMicroNode.hasChildren()) continue;
                for (IMicroNode iMicroNode2 : iMicroNode.getChildren()) {
                    if (!iMicroNode2.isElement()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public boolean hasChildElements(@Nullable String string) {
        if (this.hasChildren()) {
            for (IMicroNode iMicroNode : this.directGetChildren()) {
                if (iMicroNode.isElement()) {
                    if (!((IMicroElement)iMicroNode).getTagName().equals(string)) continue;
                    return true;
                }
                if (!iMicroNode.isContainer() || !iMicroNode.hasChildren()) continue;
                for (IMicroNode iMicroNode2 : iMicroNode.getChildren()) {
                    if (!iMicroNode2.isElement() || !((IMicroElement)iMicroNode2).getTagName().equals(string)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public boolean hasChildElements(@Nullable String string, @Nullable String string2) {
        if (StringHelper.hasNoText(string)) {
            return this.hasChildElements(string2);
        }
        if (this.hasChildren()) {
            for (IMicroNode iMicroNode : this.directGetChildren()) {
                if (iMicroNode.isElement()) {
                    IMicroElement iMicroElement = (IMicroElement)iMicroNode;
                    if (!iMicroElement.hasNamespaceURI(string) || !iMicroElement.getLocalName().equals(string2)) continue;
                    return true;
                }
                if (!iMicroNode.isContainer() || !iMicroNode.hasChildren()) continue;
                for (IMicroNode iMicroNode2 : iMicroNode.getChildren()) {
                    IMicroElement iMicroElement;
                    if (!iMicroNode2.isElement() || !(iMicroElement = (IMicroElement)iMicroNode2).hasNamespaceURI(string) || !iMicroElement.getLocalName().equals(string2)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    @Nullable
    public IMicroElement getFirstChildElement() {
        if (this.hasChildren()) {
            for (IMicroNode iMicroNode : this.directGetChildren()) {
                if (iMicroNode.isElement()) {
                    return (IMicroElement)iMicroNode;
                }
                if (!iMicroNode.isContainer() || !iMicroNode.hasChildren()) continue;
                for (IMicroNode iMicroNode2 : iMicroNode.getChildren()) {
                    if (!iMicroNode2.isElement()) continue;
                    return (IMicroElement)iMicroNode2;
                }
            }
        }
        return null;
    }

    @Override
    @Nullable
    public IMicroElement getFirstChildElement(@Nullable String string) {
        if (this.hasChildren()) {
            for (IMicroNode iMicroNode : this.directGetChildren()) {
                if (iMicroNode.isElement()) {
                    IMicroElement iMicroElement = (IMicroElement)iMicroNode;
                    if (!iMicroElement.getTagName().equals(string)) continue;
                    return iMicroElement;
                }
                if (!iMicroNode.isContainer() || !iMicroNode.hasChildren()) continue;
                for (IMicroNode iMicroNode2 : iMicroNode.getChildren()) {
                    IMicroElement iMicroElement;
                    if (!iMicroNode2.isElement() || !(iMicroElement = (IMicroElement)iMicroNode2).getTagName().equals(string)) continue;
                    return iMicroElement;
                }
            }
        }
        return null;
    }

    @Override
    @Nullable
    public IMicroElement getFirstChildElement(@Nullable String string, @Nullable String string2) {
        if (StringHelper.hasNoText(string)) {
            return this.getFirstChildElement(string2);
        }
        if (this.hasChildren()) {
            for (IMicroNode iMicroNode : this.directGetChildren()) {
                if (iMicroNode.isElement()) {
                    IMicroElement iMicroElement = (IMicroElement)iMicroNode;
                    if (!iMicroElement.hasNamespaceURI(string) || !iMicroElement.getLocalName().equals(string2)) continue;
                    return iMicroElement;
                }
                if (!iMicroNode.isContainer() || !iMicroNode.hasChildren()) continue;
                for (IMicroNode iMicroNode2 : iMicroNode.getChildren()) {
                    IMicroElement iMicroElement;
                    if (!iMicroNode2.isElement() || !(iMicroElement = (IMicroElement)iMicroNode2).hasNamespaceURI(string) || !iMicroElement.getLocalName().equals(string2)) continue;
                    return iMicroElement;
                }
            }
        }
        return null;
    }

    @Override
    @Nullable
    public String getTextContent() {
        if (!this.hasChildren()) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (IMicroNode iMicroNode : this.directGetChildren()) {
            if (iMicroNode.isText()) {
                if (((IMicroText)iMicroNode).isElementContentWhitespace()) continue;
                stringBuilder.append(iMicroNode.getNodeValue());
                continue;
            }
            if (iMicroNode.isCDATA()) {
                stringBuilder.append(iMicroNode.getNodeValue());
                continue;
            }
            if (!iMicroNode.isContainer() || !iMicroNode.hasChildren()) continue;
            for (IMicroNode iMicroNode2 : iMicroNode.getChildren()) {
                if (iMicroNode2.isText()) {
                    if (((IMicroText)iMicroNode2).isElementContentWhitespace()) continue;
                    stringBuilder.append(iMicroNode2.getNodeValue());
                    continue;
                }
                if (!iMicroNode2.isCDATA()) continue;
                stringBuilder.append(iMicroNode2.getNodeValue());
            }
        }
        return stringBuilder.toString();
    }

    @Override
    @Nullable
    public <DSTTYPE> DSTTYPE getTextContentWithConversion(@Nonnull Class<DSTTYPE> clazz) {
        String string = this.getTextContent();
        if (StringHelper.hasNoText(string)) {
            return null;
        }
        DSTTYPE DSTTYPE = TypeConverter.convertIfNecessary(string, clazz);
        return DSTTYPE;
    }

    @Override
    @Nonnull
    public IMicroElement getClone() {
        MicroElement microElement = new MicroElement(this.m_sNamespaceURI, this.m_sTagName);
        if (this.m_aAttrs != null) {
            microElement.m_aAttrs = ContainerHelper.newOrderedMap(this.m_aAttrs);
        }
        if (this.hasChildren()) {
            for (IMicroNode iMicroNode : this.directGetChildren()) {
                microElement.appendChild((IMicroNode)iMicroNode.getClone());
            }
        }
        return microElement;
    }

    @Override
    public boolean isEqualContent(@Nullable IMicroNode iMicroNode) {
        if (iMicroNode == this) {
            return true;
        }
        if (!super.isEqualContent(iMicroNode)) {
            return false;
        }
        MicroElement microElement = (MicroElement)iMicroNode;
        return EqualsUtils.equals(this.m_sNamespaceURI, microElement.m_sNamespaceURI) && this.m_sTagName.equals(microElement.m_sTagName) && EqualsUtils.equals(this.m_aAttrs, microElement.m_aAttrs);
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).appendIfNotNull("namespace", this.m_sNamespaceURI).append("tagname", this.m_sTagName).appendIfNotNull("attrs", this.m_aAttrs).toString();
    }
}

