/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.microdom.impl;

import com.phloc.commons.ICloneable;
import com.phloc.commons.equals.EqualsUtils;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.microdom.IMicroDataAware;
import com.phloc.commons.string.StringHelper;
import com.phloc.commons.string.ToStringGenerator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

final class MicroDataAware
implements IMicroDataAware,
ICloneable<MicroDataAware> {
    private final StringBuilder m_aData;

    public MicroDataAware(@Nullable CharSequence charSequence) {
        this.m_aData = StringHelper.hasNoText(charSequence) ? new StringBuilder() : new StringBuilder(charSequence);
    }

    @Override
    @Nonnull
    public StringBuilder getData() {
        return this.m_aData;
    }

    @Override
    public void setData(@Nullable CharSequence charSequence) {
        this.m_aData.setLength(0);
        this.m_aData.append(charSequence);
    }

    @Override
    public void appendData(@Nullable CharSequence charSequence) {
        this.m_aData.append(charSequence);
    }

    @Override
    public void prependData(@Nullable CharSequence charSequence) {
        this.m_aData.insert(0, charSequence);
    }

    @Override
    @Nonnull
    public MicroDataAware getClone() {
        return new MicroDataAware(this.m_aData);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof MicroDataAware)) {
            return false;
        }
        MicroDataAware microDataAware = (MicroDataAware)object;
        return EqualsUtils.equals(this.m_aData, microDataAware.m_aData);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_aData).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("data", this.m_aData).toString();
    }
}

