/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.lang;

import com.phloc.commons.id.IHasID;
import com.phloc.commons.id.IHasSimpleIntID;
import com.phloc.commons.name.IHasName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class EnumHelper {
    private static final EnumHelper s_aInstance = new EnumHelper();

    private EnumHelper() {
    }

    @Nullable
    public static <KEYTYPE, ENUMTYPE extends Enum<ENUMTYPE>> ENUMTYPE getFromIDOrNull(@Nonnull Class<ENUMTYPE> clazz, @Nullable KEYTYPE KEYTYPE) {
        return EnumHelper.getFromIDOrDefault(clazz, KEYTYPE, null);
    }

    @Nullable
    public static <KEYTYPE, ENUMTYPE extends Enum<ENUMTYPE>> ENUMTYPE getFromIDOrDefault(@Nonnull Class<ENUMTYPE> clazz, @Nullable KEYTYPE KEYTYPE, @Nullable ENUMTYPE ENUMTYPE) {
        if (clazz == null) {
            throw new NullPointerException("class");
        }
        if (KEYTYPE != null) {
            for (Enum enum_ : (Enum[])clazz.getEnumConstants()) {
                if (!((IHasID)((Object)enum_)).getID().equals(KEYTYPE)) continue;
                return (ENUMTYPE)enum_;
            }
        }
        return ENUMTYPE;
    }

    @Nonnull
    public static <KEYTYPE, ENUMTYPE extends Enum<ENUMTYPE>> ENUMTYPE getFromIDOrThrow(@Nonnull Class<ENUMTYPE> clazz, @Nullable KEYTYPE KEYTYPE) {
        ENUMTYPE ENUMTYPE = EnumHelper.getFromIDOrNull(clazz, KEYTYPE);
        if (ENUMTYPE == null) {
            throw new IllegalArgumentException("Failed to resolve ID " + KEYTYPE + " within class " + clazz);
        }
        return ENUMTYPE;
    }

    @Nullable
    public static <ENUMTYPE extends Enum<ENUMTYPE>> ENUMTYPE getFromIDCaseInsensitiveOrNull(@Nonnull Class<ENUMTYPE> clazz, @Nullable String string) {
        return EnumHelper.getFromIDCaseInsensitiveOrDefault(clazz, string, null);
    }

    @Nullable
    public static <ENUMTYPE extends Enum<ENUMTYPE>> ENUMTYPE getFromIDCaseInsensitiveOrDefault(@Nonnull Class<ENUMTYPE> clazz, @Nullable String string, @Nullable ENUMTYPE ENUMTYPE) {
        if (clazz == null) {
            throw new NullPointerException("class");
        }
        if (string != null) {
            for (Enum enum_ : (Enum[])clazz.getEnumConstants()) {
                if (!((String)((IHasID)((Object)enum_)).getID()).equalsIgnoreCase(string)) continue;
                return (ENUMTYPE)enum_;
            }
        }
        return ENUMTYPE;
    }

    @Nonnull
    public static <ENUMTYPE extends Enum<ENUMTYPE>> ENUMTYPE getFromIDCaseInsensitiveOrThrow(@Nonnull Class<ENUMTYPE> clazz, @Nullable String string) {
        ENUMTYPE ENUMTYPE = EnumHelper.getFromIDCaseInsensitiveOrNull(clazz, string);
        if (ENUMTYPE == null) {
            throw new IllegalArgumentException("Failed to resolve ID " + string + " within class " + clazz);
        }
        return ENUMTYPE;
    }

    @Nullable
    public static <ENUMTYPE extends Enum<ENUMTYPE>> ENUMTYPE getFromIDOrNull(@Nonnull Class<ENUMTYPE> clazz, int n) {
        return EnumHelper.getFromIDOrDefault(clazz, n, null);
    }

    @Nullable
    public static <ENUMTYPE extends Enum<ENUMTYPE>> ENUMTYPE getFromIDOrDefault(@Nonnull Class<ENUMTYPE> clazz, int n, @Nullable ENUMTYPE ENUMTYPE) {
        if (clazz == null) {
            throw new NullPointerException("class");
        }
        for (Enum enum_ : (Enum[])clazz.getEnumConstants()) {
            if (((IHasSimpleIntID)((Object)enum_)).getID() != n) continue;
            return (ENUMTYPE)enum_;
        }
        return ENUMTYPE;
    }

    @Nonnull
    public static <ENUMTYPE extends Enum<ENUMTYPE>> ENUMTYPE getFromIDOrThrow(@Nonnull Class<ENUMTYPE> clazz, int n) {
        ENUMTYPE ENUMTYPE = EnumHelper.getFromIDOrNull(clazz, n);
        if (ENUMTYPE == null) {
            throw new IllegalArgumentException("Failed to resolve ID " + n + " within class " + clazz);
        }
        return ENUMTYPE;
    }

    @Nullable
    public static <ENUMTYPE extends Enum<ENUMTYPE>> ENUMTYPE getFromNameOrNull(@Nonnull Class<ENUMTYPE> clazz, @Nullable String string) {
        return EnumHelper.getFromNameOrDefault(clazz, string, null);
    }

    @Nullable
    public static <ENUMTYPE extends Enum<ENUMTYPE>> ENUMTYPE getFromNameOrDefault(@Nonnull Class<ENUMTYPE> clazz, @Nullable String string, @Nullable ENUMTYPE ENUMTYPE) {
        if (clazz == null) {
            throw new NullPointerException("class");
        }
        if (string != null) {
            for (Enum enum_ : (Enum[])clazz.getEnumConstants()) {
                if (!((IHasName)((Object)enum_)).getName().equals(string)) continue;
                return (ENUMTYPE)enum_;
            }
        }
        return ENUMTYPE;
    }

    @Nonnull
    public static <ENUMTYPE extends Enum<ENUMTYPE>> ENUMTYPE getFromNameOrThrow(@Nonnull Class<ENUMTYPE> clazz, @Nullable String string) {
        ENUMTYPE ENUMTYPE = EnumHelper.getFromNameOrNull(clazz, string);
        if (ENUMTYPE == null) {
            throw new IllegalArgumentException("Failed to resolve name " + string + " within class " + clazz);
        }
        return ENUMTYPE;
    }

    @Nullable
    public static <ENUMTYPE extends Enum<ENUMTYPE>> ENUMTYPE getFromNameCaseInsensitiveOrNull(@Nonnull Class<ENUMTYPE> clazz, @Nullable String string) {
        return EnumHelper.getFromNameCaseInsensitiveOrDefault(clazz, string, null);
    }

    @Nullable
    public static <ENUMTYPE extends Enum<ENUMTYPE>> ENUMTYPE getFromNameCaseInsensitiveOrDefault(@Nonnull Class<ENUMTYPE> clazz, @Nullable String string, @Nullable ENUMTYPE ENUMTYPE) {
        if (clazz == null) {
            throw new NullPointerException("class");
        }
        if (string != null) {
            for (Enum enum_ : (Enum[])clazz.getEnumConstants()) {
                if (!((IHasName)((Object)enum_)).getName().equalsIgnoreCase(string)) continue;
                return (ENUMTYPE)enum_;
            }
        }
        return ENUMTYPE;
    }

    @Nonnull
    public static <ENUMTYPE extends Enum<ENUMTYPE>> ENUMTYPE getFromNameCaseInsensitiveOrThrow(@Nonnull Class<ENUMTYPE> clazz, @Nullable String string) {
        ENUMTYPE ENUMTYPE = EnumHelper.getFromNameCaseInsensitiveOrNull(clazz, string);
        if (ENUMTYPE == null) {
            throw new IllegalArgumentException("Failed to resolve name " + string + " within class " + clazz);
        }
        return ENUMTYPE;
    }

    @Nonnull
    public static String getEnumID(@Nonnull Enum<?> enum_) {
        return enum_.getClass().getName() + '.' + enum_.name();
    }
}

